@extends('layouts.shop')

@section('content')
    <div class="bg-gray-50 min-h-screen flex flex-col justify-center py-12 sm:px-6 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-md">
            <div class="bg-white py-8 px-4 shadow sm:rounded-lg sm:px-10 text-center">
                <svg class="mx-auto h-12 w-12 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <h2 class="mt-6 text-3xl font-extrabold text-gray-900">
                    Application Received!
                </h2>
                <p class="mt-2 text-sm text-gray-600">
                    Thank you for applying to become a reseller.
                </p>
                <div class="mt-4 bg-green-50 border border-green-200 rounded-md p-4">
                    <p class="text-sm text-green-800">
                        Your information has been successfully sent to our administration team for approval. We will review
                        your application and contact you shortly.
                    </p>
                </div>
                <div class="mt-6">
                    <a href="{{ route('home') }}"
                        class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Return to Home
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection