@extends('layouts.shop')

@section('content')
    <div class="bg-gray-50 min-h-screen py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-4xl mx-auto space-y-8">
            <div class="text-center">
                <h2 class="text-3xl font-extrabold text-gray-900 tracking-tight sm:text-4xl">
                    Become a Reseller
                </h2>
                <p class="mt-4 text-lg text-gray-500">
                    Join our network and start selling our premium products. Please fill out the form below.
                </p>
            </div>

            <div class="bg-white py-8 px-4 shadow sm:rounded-lg sm:px-10">
                <form action="{{ route('reseller.store') }}" method="POST" class="space-y-6">
                    @csrf

                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900 border-b pb-2 mb-4">Personal Information</h3>
                        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
                            <div class="sm:col-span-3">
                                <label for="name" class="block text-sm font-medium text-gray-700">Full Name</label>
                                <div class="mt-1">
                                    <input type="text" name="name" id="name" autocomplete="name" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('name', Auth::user()->name ?? '') }}">
                                </div>
                                @error('name')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-3">
                                <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                                <div class="mt-1">
                                    <input type="email" name="email" id="email" autocomplete="email" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('email', Auth::user()->email ?? '') }}">
                                </div>
                                @error('email')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-3">
                                <label for="phone" class="block text-sm font-medium text-gray-700">Phone Number</label>
                                <div class="mt-1">
                                    <input type="text" name="phone" id="phone" autocomplete="tel" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('phone') }}">
                                </div>
                                @error('phone')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>
                        </div>
                    </div>

                    <div class="pt-6">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 border-b pb-2 mb-4">Contact Information</h3>
                        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
                            <div class="sm:col-span-6">
                                <label for="address" class="block text-sm font-medium text-gray-700">Street Address</label>
                                <div class="mt-1">
                                    <textarea id="address" name="address" rows="3" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border border-gray-300 rounded-md p-2">{{ old('address') }}</textarea>
                                </div>
                                @error('address')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-2">
                                <label for="city" class="block text-sm font-medium text-gray-700">City</label>
                                <div class="mt-1">
                                    <input type="text" name="city" id="city" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('city') }}">
                                </div>
                                @error('city')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-2">
                                <label for="state" class="block text-sm font-medium text-gray-700">State / Province</label>
                                <div class="mt-1">
                                    <input type="text" name="state" id="state" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('state') }}">
                                </div>
                                @error('state')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-2">
                                <label for="postal_code" class="block text-sm font-medium text-gray-700">ZIP / Postal
                                    Code</label>
                                <div class="mt-1">
                                    <input type="text" name="postal_code" id="postal_code" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('postal_code') }}">
                                </div>
                                @error('postal_code')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>
                        </div>
                    </div>

                    <div class="pt-6">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 border-b pb-2 mb-4">Company & GST Information
                        </h3>
                        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
                            <div class="sm:col-span-3">
                                <label for="company_name" class="block text-sm font-medium text-gray-700">Company
                                    Name</label>
                                <div class="mt-1">
                                    <input type="text" name="company_name" id="company_name" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('company_name') }}">
                                </div>
                                @error('company_name')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-3">
                                <label for="company_website" class="block text-sm font-medium text-gray-700">Company Website
                                    (Optional)</label>
                                <div class="mt-1">
                                    <input type="url" name="company_website" id="company_website"
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        placeholder="https://example.com" value="{{ old('company_website') }}">
                                </div>
                                @error('company_website')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>

                            <div class="sm:col-span-3">
                                <label for="gst_number" class="block text-sm font-medium text-gray-700">GST Number</label>
                                <div class="mt-1">
                                    <input type="text" name="gst_number" id="gst_number" required
                                        class="shadow-sm focus:ring-[#9B2D69] focus:border-[#9B2D69] block w-full sm:text-sm border-gray-300 rounded-md p-2 border"
                                        value="{{ old('gst_number') }}">
                                </div>
                                @error('gst_number')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                            </div>
                        </div>
                    </div>

                    <div class="pt-5">
                        <div class="flex justify-end">
                            <button type="button" onclick="window.location='{{ route('home') }}'"
                                class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B2D69]">
                                Cancel
                            </button>
                            <button type="submit"
                                class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-[#9B2D69] hover:bg-[#7a2454] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B2D69]">
                                Submit Application
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection