@extends('layouts.shop')

@section('title', 'Payment - ' . $order->order_number)

@section('content')
    <div class="bg-gray-50 py-12">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Select Payment Method</h1>

            <div class="bg-white shadow overflow-hidden sm:rounded-lg mb-8">
                <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Order Summary</h3>
                </div>
                <div class="px-4 py-5 sm:p-6">
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-8 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">Order Number</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $order->order_number }}</dd>
                        </div>
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500 mb-2">Order Breakdown</dt>
                            <dd class="mt-1 text-sm text-gray-900 space-y-2">
                                <div class="flex justify-between">
                                    <span>Subtotal</span>
                                    <span>₹{{ number_format($order->subtotal, 2) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Shipping</span>
                                    <span>₹{{ number_format($order->shipping_cost, 2) }}</span>
                                </div>
                                @if($order->discount > 0)
                                    <div class="flex justify-between text-green-600">
                                        <span>Discount</span>
                                        <span>-₹{{ number_format($order->discount, 2) }}</span>
                                    </div>
                                @endif
                                @if($order->gift_card_discount > 0)
                                    <div class="flex justify-between text-green-600">
                                        <span>Gift Card</span>
                                        <span>-₹{{ number_format($order->gift_card_discount, 2) }}</span>
                                    </div>
                                @endif
                                @if($order->points_discount > 0)
                                    <div class="flex justify-between text-green-600">
                                        <span>Points Redeemed ({{ $order->points_redeemed }})</span>
                                        <span>-₹{{ number_format($order->points_discount, 2) }}</span>
                                    </div>
                                @endif
                                <div class="flex justify-between font-bold text-lg border-t pt-2 mt-2">
                                    <span>Total Amount</span>
                                    <span>₹{{ number_format($order->total, 2) }}</span>
                                </div>
                            </dd>
                        </div>
                    </dl>
                </div>
            </div>

            <div class="space-y-4">
                @if($isFreeOrder ?? false)
                    <!-- Free Order -->
                    <div class="bg-white shadow sm:rounded-lg p-6 flex items-center justify-between">
                        <div class="flex items-center">
                            <div
                                class="h-10 w-10 flex-shrink-0 flex items-center justify-center bg-green-100 rounded-full text-green-600">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h4 class="text-lg font-medium text-gray-900">Complete Order</h4>
                                <p class="text-sm text-gray-500">Order fully paid via Gift Card / Points</p>
                            </div>
                        </div>
                        <form action="{{ route('checkout.free', $order->id) }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded">
                                Place Order
                            </button>
                        </form>
                    </div>
                @else
                    <!-- COD Option -->
                    @if($isCodEligible)
                        <div class="bg-white shadow sm:rounded-lg p-6 flex items-center justify-between">
                            <div class="flex items-center">
                                <div
                                    class="h-10 w-10 flex-shrink-0 flex items-center justify-center bg-green-100 rounded-full text-green-600">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                </div>
                                <div class="ml-4">
                                    <h4 class="text-lg font-medium text-gray-900">Cash on Delivery</h4>
                                    <p class="text-sm text-gray-500">Pay when you receive the order</p>
                                </div>
                            </div>
                            <form action="{{ route('checkout.cod', $order->id) }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded">
                                    Confirm Order
                                </button>
                            </form>
                        </div>
                    @endif


                    <!-- PhonePe Option -->
                    @if($settings->phonepe_enabled)
                        <div class="bg-white shadow sm:rounded-lg p-6 flex items-center justify-between mt-4 border border-blue-200"
                            style="display: flex;">
                            <div class="flex items-center">
                                <div
                                    class="h-10 w-10 flex-shrink-0 flex items-center justify-center bg-blue-100 rounded-full text-blue-600">
                                    <!-- PhonePe Logo / Icon -->
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor">
                                        <path
                                            d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 15h-2v-6h2v6zm-1-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm5 7h-2v-6h2v6zm-1-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z" />
                                    </svg>
                                </div>
                                <div class="ml-4">
                                    <h4 class="text-lg font-medium text-gray-900">PhonePe / UPI</h4>
                                    <p class="text-sm text-gray-500">Pay securely with UPI, Cards, or Wallet</p>
                                </div>
                            </div>
                            <form action="{{ route('checkout.phonepe.init', $order->id) }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded shadow-md transition duration-150 ease-in-out"
                                    style="background-color: #2563eb; color: #ffffff;">
                                    Pay with PhonePe
                                </button>
                            </form>
                        </div>
                    @endif
                @endif
            </div>

            @if(!($isFreeOrder ?? false))
                <!-- Razorpay Option -->
                @if($settings->razorpay_enabled)
                    <div class="bg-white shadow sm:rounded-lg p-6 flex items-center justify-between mt-4 border border-blue-600">
                        <div class="flex items-center">
                            <div class="h-10 w-10 flex-shrink-0 flex items-center justify-center bg-blue-50 rounded-full">
                                <!-- Simple Razorpay Icon or SVG -->
                                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                                    <path
                                        d="M2.213 6.944L8.7 15.116H2.213v1.981h11.458l2.91-3.667H10.51l-4.708-5.93h12.59L21.787 3H7.625l-5.412 3.944z" />
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h4 class="text-lg font-medium text-gray-900">Pay with Razorpay</h4>
                                <p class="text-sm text-gray-500">Credit/Debit Card, Netbanking, UPI</p>
                            </div>
                        </div>
                        <button id="rzp-button1"
                            class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded shadow-md transition duration-150 ease-in-out">
                            Pay Now
                        </button>
                    </div>
                @endif
            @endif
        </div>

        @if(!($isFreeOrder ?? false) && $settings->razorpay_enabled)
            <form action="{{ route('checkout.razorpay', $order->id) }}" method="POST" id="razorpay-form">
                @csrf
                <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                <input type="hidden" name="razorpay_order_id" id="razorpay_order_id">
                <input type="hidden" name="razorpay_signature" id="razorpay_signature">
            </form>

            <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
            <script>
                var options = {
                    "key": "{{ $settings->razorpay_key_id }}",
                    "amount": "{{ $order->total * 100 }}",
                    "currency": "INR",
                    "name": "{{ config('app.name') }}",
                    "description": "Order #{{ $order->order_number }}",
                    "image": "{{ asset('images/logo.png') }}",
                    "order_id": "{{ $order->razorpay_order_id }}",
                    "handler": function (response) {
                        document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
                        document.getElementById('razorpay_order_id').value = response.razorpay_order_id;
                        document.getElementById('razorpay_signature').value = response.razorpay_signature;
                        document.getElementById('razorpay-form').submit();
                    },
                    "prefill": {
                        "name": "{{ $order->user ? $order->user->name : $order->name }}",
                        "email": "{{ $order->email }}",
                        "contact": "{{ $order->phone }}"
                    },
                    "notes": {
                        "address": "Razorpay Corporate Office"
                    },
                    "theme": {
                        "color": "#3399cc"
                    }
                };
                var rzp1 = new Razorpay(options);
                document.getElementById('rzp-button1').onclick = function (e) {
                    rzp1.open();
                    e.preventDefault();
                }
            </script>
        @endif
@endsection