<!-- Recent Searches -->
@if(isset($recentSearches) && $recentSearches->count() > 0)
    <div class="mb-8 border-b border-gray-200 pb-6">
        <h3 class="font-bold text-gray-900 mb-4 text-sm uppercase tracking-wide">Your Recent Searches</h3>
        <div class="flex flex-wrap gap-2">
            @foreach($recentSearches as $term)
                <a href="{{ route('shop.index', ['search' => $term]) }}"
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-700 hover:bg-gray-200 hover:text-gray-900 transition-colors">
                    <svg class="mr-1.5 h-3 w-3 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    {{ $term }}
                </a>
            @endforeach
        </div>
    </div>
@endif

<form action="{{ request()->url() }}" method="GET" id="filter-form">
    <!-- Keep existing search if present -->
    @if(request('search'))
        <input type="hidden" name="search" value="{{ request('search') }}">
    @endif

    <!-- Keep existing sort if present -->
    @if(request('sort'))
        <input type="hidden" name="sort" value="{{ request('sort') }}">
    @endif

    <!-- Categories Filter -->
    @if(isset($categories) && $categories->count() > 0 && !isset($category))
        <div class="border-b border-gray-200 py-6">
            <h3 class="-my-3 flow-root">
                <span class="font-bold text-gray-900 text-sm uppercase tracking-wider">Categories</span>
            </h3>
            <div class="pt-6">
                <div class="space-y-4 max-h-60 overflow-y-auto pr-2 custom-scrollbar">
                    @foreach($categories as $cat)
                        <div class="flex items-center justify-between group">
                            <div class="flex items-center">
                                <input id="filter-cat-{{ $cat->id }}" name="categories[]" value="{{ $cat->id }}" type="checkbox"
                                    {{ in_array($cat->id, request('categories', [])) ? 'checked' : '' }}
                                    onchange="this.form.submit()"
                                    class="h-4 w-4 border-gray-300 rounded text-[#9B2D69] focus:ring-[#9B2D69] transition-colors">
                                <label for="filter-cat-{{ $cat->id }}"
                                    class="ml-3 text-sm text-gray-600 group-hover:text-gray-900 cursor-pointer transition-colors">
                                    {{ $cat->name }}
                                </label>
                            </div>
                            <span
                                class="text-xs text-gray-400 font-medium bg-gray-50 px-2 py-0.5 rounded-full group-hover:bg-gray-100 transition-colors">
                                {{ $cat->products_count }}
                            </span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Subcategories Filter -->
    @if(isset($subcategories) && $subcategories->count() > 0)
        <div class="border-b border-gray-200 py-6">
            <h3 class="-my-3 flow-root">
                <span class="font-bold text-gray-900 text-sm uppercase tracking-wider">Subcategories</span>
            </h3>
            <div class="pt-6">
                <div class="space-y-4 max-h-60 overflow-y-auto pr-2 custom-scrollbar">
                    @foreach($subcategories as $sub)
                        <div class="flex items-center justify-between group">
                            <div class="flex items-center">
                                <input id="filter-sub-{{ $sub->id }}" name="subcategories[]" value="{{ $sub->id }}"
                                    type="checkbox" {{ in_array($sub->id, request('subcategories', [])) ? 'checked' : '' }}
                                    onchange="this.form.submit()"
                                    class="h-4 w-4 border-gray-300 rounded text-[#9B2D69] focus:ring-[#9B2D69] transition-colors">
                                <label for="filter-sub-{{ $sub->id }}"
                                    class="ml-3 text-sm text-gray-600 group-hover:text-gray-900 cursor-pointer transition-colors">
                                    {{ $sub->name }}
                                </label>
                            </div>
                            <span
                                class="text-xs text-gray-400 font-medium bg-gray-50 px-2 py-0.5 rounded-full group-hover:bg-gray-100 transition-colors">
                                {{ $sub->products_count }}
                            </span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Price Filter -->
    @if(isset($minPrice) && isset($maxPrice) && $minPrice != $maxPrice)
        <div class="border-b border-gray-200 py-6">
            <h3 class="-my-3 flow-root">
                <span class="font-bold text-gray-900 text-sm uppercase tracking-wider">Price Range</span>
            </h3>
            <div class="pt-10 px-2">
                <div id="price-slider-{{ $idPrefix ?? 'desktop' }}" class="mb-6"></div>
                <div class="flex justify-between items-center text-sm">
                    <div class="flex-1">
                        <span class="text-gray-500 text-xs block uppercase">Min</span>
                        <span class="font-bold text-gray-900">₹<span
                                id="price-min-display-{{ $idPrefix ?? 'desktop' }}"></span></span>
                    </div>
                    <div class="px-3 text-gray-300">
                        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </div>
                    <div class="flex-1 text-right">
                        <span class="text-gray-500 text-xs block uppercase">Max</span>
                        <span class="font-bold text-gray-900">₹<span
                                id="price-max-display-{{ $idPrefix ?? 'desktop' }}"></span></span>
                    </div>
                </div>
                <input type="hidden" name="min_price" id="input-min-price-{{ $idPrefix ?? 'desktop' }}"
                    value="{{ request('min_price', $minPrice) }}">
                <input type="hidden" name="max_price" id="input-max-price-{{ $idPrefix ?? 'desktop' }}"
                    value="{{ request('max_price', $maxPrice) }}">

                <button type="submit"
                    class="mt-6 w-full bg-[#9B2D69] text-white px-4 py-2.5 rounded-lg text-sm font-bold uppercase tracking-widest hover:bg-[#7a2454] transition-all shadow-sm active:scale-95">
                    Apply Price
                </button>
            </div>
        </div>
    @endif

    @if(request()->has('categories') || request()->has('subcategories') || request()->has('min_price') || request()->has('max_price'))
        <a href="{{ request()->url() }}"
            class="mt-6 flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-500 hover:text-[#9B2D69] border border-gray-200 rounded-lg hover:border-[#9B2D69] transition-all">
            <svg class="w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
            </svg>
            Clear All Filters
        </a>
    @endif
</form>

<style>
    .custom-scrollbar::-webkit-scrollbar {
        width: 4px;
    }

    .custom-scrollbar::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb {
        background: #e2e2e2;
        border-radius: 10px;
    }

    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background: #9B2D69;
    }

    /* noUiSlider Overrides */
    .noUi-connect {
        background: #9B2D69 !important;
    }

    .noUi-horizontal {
        height: 6px !important;
        border: none !important;
        box-shadow: none !important;
        background: #f3f4f6 !important;
    }

    .noUi-handle {
        width: 18px !important;
        height: 18px !important;
        right: -9px !important;
        top: -6px !important;
        border-radius: 50% !important;
        background: #fff !important;
        border: 2px solid #9B2D69 !important;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
        cursor: pointer !important;
    }

    .noUi-handle:before,
    .noUi-handle:after {
        display: none !important;
    }
</style>