@extends('layouts.shop')

@section('title', 'Order Success')

@section('content')
    <div class="bg-gray-50 h-screen flex flex-col justify-center py-12 sm:px-6 lg:px-8">
        <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
            <div class="bg-white py-8 px-4 shadow sm:rounded-lg sm:px-10 text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100 mb-4">
                    <svg class="h-6 w-6 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                </div>
                <h2 class="text-3xl font-extrabold text-gray-900 mb-2">Order Confirmed!</h2>
                <p class="text-gray-600 mb-6">Thank you for your purchase. Your order number is <span
                        class="font-bold text-indigo-600">{{ $order->order_number }}</span>.</p>

                <div class="border-t border-gray-200 py-4">
                    <p class="text-sm text-gray-500">We have sent a confirmation email to
                        <strong>{{ $order->email }}</strong>.
                    </p>
                </div>

                <div class="mt-6">
                    <a href="{{ route('shop.index') }}"
                        class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Continue Shopping
                    </a>
                </div>
                @if(Auth::check())
                    <div class="mt-4">
                        <a href="{{ route('user.orders') }}" class="text-sm font-medium text-indigo-600 hover:text-indigo-500">
                            View My Orders
                        </a>
                    </div>
                @endif
            </div>
        </div>
        <div class="mt-4">
            <p class="text-sm text-gray-500" id="redirect-msg">Redirecting to My Orders in 3 seconds...</p>
        </div>
    </div>
    </div>
    </div>

    <script>
        setTimeout(function () {
            window.location.href = "{{ route('user.orders') }}";
        }, 3000);
    </script>
@endsection