@extends('layouts.shop')

@php
    $pageTitle = $settings->site_name ?? 'Hair Niche'; // Default
    $metaDescription = '';
    $metaKeywords = '';

    if (isset($subcategory)) {
        $pageTitle = $subcategory->seo_title ?? $subcategory->name . ' - ' . ($settings->site_name ?? 'Hair Niche');
        $metaDescription = $subcategory->meta_description ?? '';
    } elseif (isset($category)) {
        $pageTitle = $category->seo_title ?? $category->name . ' - ' . ($settings->site_name ?? 'Hair Niche');
        $metaDescription = $category->meta_description ?? '';
    }
@endphp

@section('title', $pageTitle)
@section('meta_description', $metaDescription)
@section('meta_keywords', $metaKeywords)

@push('schema_markup')
    @php
        $shopSchema = \App\Models\SeoSetting::where('page_name', 'shop')->value('schema_markup');
    @endphp
    @if($shopSchema)
        {!! $shopSchema !!}
    @endif
    @if(isset($category) && $category->schema_markup)
        {!! $category->schema_markup !!}
    @endif
    @if(isset($subcategory) && $subcategory->schema_markup)
        {!! $subcategory->schema_markup !!}
    @endif
    @if(isset($product) && $product->schema_markup)
        {!! $product->schema_markup !!}
    @endif
@endpush

@section('content')
    <div class="bg-white" x-data="{ mobileFiltersOpen: false }">
        <!-- Header -->
        <div id="shop-header" class="bg-gradient-to-r from-[#9B2D69] to-[#7a2454] py-8 md:py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h1 class="text-3xl md:text-5xl font-extrabold text-white uppercase tracking-tight">
                    {{ isset($subcategory) ? $subcategory->name : (isset($category) ? $category->name : 'Shop All') }}
                </h1>
                <nav class="flex mt-4 text-sm font-medium text-pink-100/80">
                    <a href="{{ route('home') }}" class="hover:text-white transition-colors">Home</a>
                    <span class="mx-2 opacity-50">/</span>
                    <a href="{{ route('shop.index') }}" class="hover:text-white transition-colors">Shop</a>
                    @if(isset($category))
                        <span class="mx-2 opacity-50">/</span>
                        <a href="{{ route('shop.category', $category->slug) }}"
                            class="{{ isset($subcategory) ? 'hover:text-white transition-colors' : 'text-white font-bold' }}">
                            {{ $category->name }}
                        </a>
                    @endif
                    @if(isset($subcategory))
                        <span class="mx-2 opacity-50">/</span>
                        <span class="text-white font-bold">{{ $subcategory->name }}</span>
                    @endif
                </nav>
            </div>
        </div>

        <!-- Mobile filter dialog -->
        <div x-show="mobileFiltersOpen" class="relative z-50 lg:hidden" role="dialog" aria-modal="true" x-cloak>
            <div x-show="mobileFiltersOpen" x-transition:enter="transition-opacity ease-linear duration-300"
                x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="transition-opacity ease-linear duration-300" x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0" class="fixed inset-0 bg-black/60 backdrop-blur-sm"
                @click="mobileFiltersOpen = false"></div>

            <div class="fixed inset-0 z-50 flex">
                <div x-show="mobileFiltersOpen" x-transition:enter="transition ease-in-out duration-300 transform"
                    x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
                    x-transition:leave="transition ease-in-out duration-300 transform"
                    x-transition:leave-start="translate-x-0" x-transition:leave-end="translate-x-full"
                    class="relative ml-auto flex h-full w-full max-w-xs flex-col overflow-y-auto bg-white py-4 pb-12 shadow-2xl">
                    <div class="flex items-center justify-between px-6 pb-4 border-b border-gray-100">
                        <h2 class="text-xl font-bold text-gray-900 uppercase tracking-tight">Filters</h2>
                        <button type="button" @click="mobileFiltersOpen = false"
                            class="-mr-2 flex h-10 w-10 items-center justify-center rounded-full text-gray-400 hover:text-gray-600 hover:bg-gray-100 transition-all">
                            <span class="sr-only">Close menu</span>
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <!-- Filters -->
                    <div class="mt-4 px-6">
                        @include('shop.partials.filters', ['idPrefix' => 'mobile'])
                    </div>
                </div>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 md:py-16">
            <div class="lg:grid lg:grid-cols-4 lg:gap-x-12">
                <!-- Sidebar Filters (Desktop) -->
                <aside id="shop-sidebar" class="hidden lg:block space-y-8">
                    @include('shop.partials.filters', ['idPrefix' => 'desktop'])
                </aside>

                <!-- Product Grid Container -->
                <div class="mt-6 lg:mt-0 lg:col-span-3">
                    <!-- Sorting and Results Count -->
                    <div
                        class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-8 pb-6 border-b border-gray-100">
                        <div class="flex items-center justify-between sm:justify-start gap-4">
                            <p class="text-xs md:text-sm text-gray-600 font-medium">
                                Showing <span
                                    class="text-gray-900 font-bold">{{ $products->count() > 0 ? $products->firstItem() : 0 }}</span>–<span
                                    class="text-gray-900 font-bold">{{ $products->count() > 0 ? $products->lastItem() : 0 }}</span>
                                of <span class="text-gray-900 font-bold">{{ $products->total() }}</span> results
                            </p>

                            <!-- Mobile Filter Trigger -->
                            <button type="button" @click="mobileFiltersOpen = true"
                                class="lg:hidden flex items-center gap-2 px-4 py-2 bg-gray-50 rounded-lg text-sm font-bold text-gray-900 hover:bg-gray-100 transition-colors border border-gray-200">
                                <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z" />
                                </svg>
                                <span>Filters</span>
                            </button>
                        </div>

                        <div class="flex items-center gap-3">
                            <label for="sort-select"
                                class="hidden sm:block text-xs font-bold text-gray-400 uppercase tracking-widest">Sort:</label>
                            <div class="relative flex-1 sm:flex-none">
                                <select id="sort-select" name="sort"
                                    class="appearance-none block w-full sm:w-48 bg-white border border-gray-200 rounded-xl py-2.5 pl-4 pr-10 text-sm font-semibold text-gray-900 focus:border-[#9B2D69] focus:outline-none focus:ring-2 focus:ring-[#9B2D69]/10 transition-all cursor-pointer"
                                    onchange="window.location.href = updateUrlParameter(window.location.href, 'sort', this.value)">
                                    <option value="latest" {{ request('sort', 'latest') == 'latest' ? 'selected' : '' }}>
                                        Latest Arrivals</option>
                                    <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price:
                                        Low to High</option>
                                    <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price:
                                        High to Low</option>
                                    <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Name: A to
                                        Z</option>
                                    <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Name: Z
                                        to A</option>
                                </select>
                                <div
                                    class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-3 text-gray-400">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($products->count() > 0)
                        <div id="products-grid" class="grid grid-cols-2 lg:grid-cols-3 gap-y-10 gap-x-4 md:gap-x-8">
                            @include('shop.partials.product-grid', ['products' => $products])
                        </div>

                        <!-- Shimmer Loading Indicator -->
                        <div id="loading-indicator"
                            class="hidden grid grid-cols-2 lg:grid-cols-3 gap-y-10 gap-x-4 md:gap-x-8 mt-12">
                            @for($i = 0; $i < 4; $i++)
                                <div class="animate-pulse">
                                    <div class="bg-gray-100 rounded-2xl aspect-[4/5] mb-4"></div>
                                    <div class="h-4 bg-gray-100 rounded-full w-3/4 mb-3"></div>
                                    <div class="h-4 bg-gray-100 rounded-full w-1/2"></div>
                                </div>
                            @endfor
                        </div>

                        <!-- End of Products Message -->
                        <div id="end-of-products" class="hidden mt-16 text-center border-t border-gray-100 pt-12">
                            <span
                                class="inline-flex items-center px-4 py-1.5 rounded-full bg-gray-50 text-xs font-bold text-gray-400 uppercase tracking-widest">
                                You've reached the end
                            </span>
                        </div>

                        <!-- Pagination (hidden when infinite scroll is active) -->
                        <div id="pagination-links" class="mt-16">
                            {{ $products->appends(request()->query())->links() }}
                        </div>
                    @else
                        <div class="text-center py-32 bg-gray-50 rounded-3xl border-2 border-dashed border-gray-200">
                            <div class="max-w-xs mx-auto">
                                <svg class="mx-auto h-16 w-16 text-gray-300" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                                <h3 class="mt-6 text-xl font-bold text-gray-900 uppercase">No items found</h3>
                                <p class="mt-2 text-sm text-gray-500">We couldn't find anything matching your filters. Try
                                    adjusting your search.</p>
                                <a href="{{ request()->url() }}"
                                    class="mt-8 inline-flex items-center px-6 py-3 border border-transparent text-sm font-bold rounded-xl shadow-lg text-white bg-[#9B2D69] hover:bg-[#7a2454] transition-all active:scale-95 uppercase tracking-widest">
                                    Clear all filters
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.0/nouislider.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.0/nouislider.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            function initPriceSlider(prefix) {
                var slider = document.getElementById('price-slider-' + prefix);
                if (!slider) return;

                var minPrice = {{ isset($minPrice) ? $minPrice : 0 }};
                var maxPrice = {{ isset($maxPrice) ? $maxPrice : 10000 }};

                var currentMin = {{ request('min_price') ?? (isset($minPrice) ? $minPrice : 0) }};
                var currentMax = {{ request('max_price') ?? (isset($maxPrice) ? $maxPrice : 10000) }};

                if (minPrice === maxPrice) return;

                noUiSlider.create(slider, {
                    start: [currentMin, currentMax],
                    connect: true,
                    range: {
                        'min': minPrice,
                        'max': maxPrice
                    },
                    step: 10,
                    format: {
                        to: function (value) { return Math.round(value); },
                        from: function (value) { return Number(value); }
                    }
                });

                var minInput = document.getElementById('input-min-price-' + prefix);
                var maxInput = document.getElementById('input-max-price-' + prefix);
                var minDisplay = document.getElementById('price-min-display-' + prefix);
                var maxDisplay = document.getElementById('price-max-display-' + prefix);

                slider.noUiSlider.on('update', function (values, handle) {
                    var value = values[handle];
                    if (handle) {
                        maxInput.value = value;
                        maxDisplay.textContent = Number(value).toLocaleString();
                    } else {
                        minInput.value = value;
                        minDisplay.textContent = Number(value).toLocaleString();
                    }
                });
            }

            // Initialize both desktop and mobile sliders
            initPriceSlider('desktop');
            initPriceSlider('mobile');
        });
    </script>

    <!-- URL Parameter Helper -->
    <script>
        function updateUrlParameter(url, param, value) {
            const urlObj = new URL(url);
            urlObj.searchParams.set(param, value);
            urlObj.searchParams.delete('page');
            return urlObj.toString();
        }
    </script>

    <!-- Infinite Scroll Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            let currentPage = {{ $products->count() > 0 ? $products->currentPage() : 1 }};
            let lastPage = {{ $products->count() > 0 ? $products->lastPage() : 1 }};
            let loading = false;
            const productsGrid = document.getElementById('products-grid');
            const loadingIndicator = document.getElementById('loading-indicator');
            const endOfProducts = document.getElementById('end-of-products');
            const paginationLinks = document.getElementById('pagination-links');

            if (paginationLinks && lastPage > 1) {
                paginationLinks.style.display = 'none';
            }

            function loadMoreProducts() {
                if (loading || currentPage >= lastPage || !productsGrid) return;

                loading = true;
                loadingIndicator.classList.remove('hidden');

                const url = new URL(window.location.href);
                url.searchParams.set('page', currentPage + 1);

                fetch(url.toString(), {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.html) {
                            const tempDiv = document.createElement('div');
                            tempDiv.innerHTML = data.html;

                            while (tempDiv.firstChild) {
                                productsGrid.appendChild(tempDiv.firstChild);
                            }

                            currentPage = data.next_page;

                            if (!data.has_more) {
                                endOfProducts.classList.remove('hidden');
                            }
                        }
                    })
                    .catch(error => {
                        console.error('Error loading products:', error);
                    })
                    .finally(() => {
                        loading = false;
                        loadingIndicator.classList.add('hidden');
                    });
            }

            window.addEventListener('scroll', function () {
                if (loading || currentPage >= lastPage) return;

                const scrollPosition = window.innerHeight + window.scrollY;
                const pageHeight = document.documentElement.scrollHeight;

                if (scrollPosition >= pageHeight - 600) {
                    loadMoreProducts();
                }
            });
        });
    </script>
@endpush