@extends('layouts.shop')

@section('title', $blog->meta_title ?? $blog->title . ' | Hair Niche By Shelly')
@section('meta_description', $blog->meta_description ?? Str::limit($blog->excerpt, 160))

@if(!empty($blog->schema_markup))
    @push('head_scripts')
        <script type="application/ld+json">
                                    {!! $blog->schema_markup !!}
                                </script>
    @endpush
@endif

@section('content')
    <div class="bg-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="lg:grid lg:grid-cols-12 lg:gap-8">
                <!-- Main Content -->
                <div class="lg:col-span-8">
                    <article class="prose prose-lg max-w-none text-gray-500">
                        <div class="mb-8">
                            <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-2">{{ $blog->title }}</h1>
                            <div class="flex items-center text-sm text-gray-500">
                                <span>Published on
                                    {{ $blog->published_at ? $blog->published_at->format('F d, Y') : '' }}</span>
                            </div>
                        </div>

                        @if($blog->image)
                            <div class="mb-8 rounded-xl overflow-hidden shadow-sm">
                                <img src="{{ Storage::url($blog->image) }}" alt="{{ $blog->title }}"
                                    class="w-full h-auto object-cover">
                            </div>
                        @endif

                        <div class="mt-6 text-gray-800 space-y-4">
                            {!! $blog->content !!}
                        </div>
                    </article>

                    <div class="mt-12 pt-8 border-t border-gray-200">
                        <a href="{{ route('blogs.index') }}"
                            class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
                            &larr; Back to all posts
                        </a>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="lg:col-span-4 mt-12 lg:mt-0 pl-0 lg:pl-8">
                    <div class="bg-gray-50 rounded-xl p-6 border border-gray-100 sticky top-24">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">You might also like</h3>
                        <div class="space-y-6">
                            @forelse($recentBlogs as $recent)
                                <div class="flex items-start">
                                    @if($recent->image)
                                        <a href="{{ route('blogs.show', $recent->slug) }}" class="flex-shrink-0 mr-3">
                                            <img src="{{ Storage::url($recent->image) }}" class="h-16 w-16 rounded object-cover"
                                                alt="{{ $recent->title }}">
                                        </a>
                                    @else
                                        <div class="flex-shrink-0 mr-3 h-16 w-16 bg-gray-200 rounded"></div>
                                    @endif
                                    <div>
                                        <h4 class="text-sm font-medium text-gray-900">
                                            <a href="{{ route('blogs.show', $recent->slug) }}"
                                                class="hover:text-indigo-600 transition-colors">
                                                {{ $recent->title }}
                                            </a>
                                        </h4>
                                        <p class="text-xs text-gray-500 mt-1">
                                            {{ $recent->published_at ? $recent->published_at->format('M d, Y') : '' }}
                                        </p>
                                    </div>
                                </div>
                            @empty
                                <p class="text-sm text-gray-500">No other recent posts.</p>
                            @endforelse
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection