@forelse($blogs as $blog)
    <div
        class="bg-white rounded-xl shadow-sm overflow-hidden hover:shadow-lg transition-shadow duration-300 flex flex-col h-full blog-item">
        <a href="{{ route('blogs.show', $blog->slug) }}" class="block relative h-48 overflow-hidden">
            @if($blog->image)
                <img src="{{ Storage::url($blog->image) }}" alt="{{ $blog->title }}"
                    class="w-full h-full object-cover transform hover:scale-110 transition-transform duration-500">
            @else
                <div class="w-full h-full bg-gray-200 flex items-center justify-center text-gray-400">
                    <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                        </path>
                    </svg>
                </div>
            @endif
        </a>
        <div class="p-6 flex-1 flex flex-col">
            <div class="text-sm text-indigo-600 font-semibold mb-2">
                {{ $blog->published_at ? $blog->published_at->format('M d, Y') : '' }}
            </div>
            <a href="{{ route('blogs.show', $blog->slug) }}" class="block mt-1">
                <h3 class="text-xl font-bold text-gray-900 hover:text-indigo-600 transition-colors line-clamp-2">
                    {{ $blog->title }}
                </h3>
                <p class="mt-3 text-base text-gray-500 line-clamp-3">
                    {{ $blog->excerpt }}
                </p>
            </a>
            <div class="mt-6 pt-4 border-t border-gray-100 flex items-center justify-between">
                <div class="flex items-center">
                    <span class="sr-only">Lugani Herbs</span>
                </div>
                <a href="{{ route('blogs.show', $blog->slug) }}"
                    class="text-indigo-600 hover:text-indigo-800 font-medium text-sm flex items-center group">
                    Read more <span class="ml-1 transform group-hover:translate-x-1 transition-transform">&rarr;</span>
                </a>
            </div>
        </div>
    </div>
@empty
    {{-- Only show if it's the first page --}}
    @if(isset($blogs) && method_exists($blogs, 'currentPage') && $blogs->currentPage() == 1)
        <div class="col-span-3 text-center py-12">
            <p class="text-gray-500 text-lg">No blog posts found yet. Check back soon!</p>
        </div>
    @endif
@endforelse