@extends('layouts.shop')

@section('title', 'Blog | Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Our Blog</h1>
                <p class="mt-4 text-xl text-gray-500 max-w-2xl mx-auto">Latest news, health tips, and Ayurvedic wisdom from
                    Lugani Herbs.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8" id="blog-posts-container">
                @include('shop.blog.partials.item', ['blogs' => $blogs])
            </div>

            {{-- Loader --}}
            <div id="loading" class="text-center py-12 hidden">
                <div class="inline-flex items-center px-4 py-2 font-semibold leading-6 text-sm shadow rounded-md text-white bg-indigo-500 hover:bg-indigo-400 transition ease-in-out duration-150 cursor-not-allowed"
                    disabled="">
                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor"
                            d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                        </path>
                    </svg>
                    Loading more...
                </div>
            </div>

            <div class="mt-12 hidden">
                {{ $blogs->links() }}
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let page = 1;
        let hasMore = {{ $blogs->hasMorePages() ? 'true' : 'false' }};
        let loading = false;

        window.addEventListener('scroll', () => {
            if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 500) {
                if (!loading && hasMore) {
                    loadMoreData(++page);
                }
            }
        });

        function loadMoreData(page) {
            loading = true;
            document.getElementById('loading').classList.remove('hidden');

            let url = new URL(window.location.href);
            url.searchParams.set('page', page);

            fetch(url, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
                .then(response => {
                    if (!response.ok) throw new Error('Network response was not ok');
                    return response.json();
                })
                .then(data => {
                    if (data.html) {
                        document.getElementById('blog-posts-container').insertAdjacentHTML('beforeend', data.html);
                        hasMore = data.hasMore;
                    } else {
                        hasMore = false;
                    }
                    loading = false;
                    document.getElementById('loading').classList.add('hidden');
                })
                .catch(error => {
                    console.error('Error:', error);
                    loading = false;
                    document.getElementById('loading').classList.add('hidden');
                });
        }
    </script>
@endpush