@extends('layouts.reseller')

@section('content')
    <div class="max-w-4xl mx-auto bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-100">
            <h2 class="text-xl font-bold text-gray-900">My Profile</h2>
        </div>

        <form action="{{ route('reseller.profile.update') }}" method="POST" enctype="multipart/form-data"
            class="p-6 space-y-6">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Logo -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Company Logo</label>
                    <div class="flex items-center space-x-6">
                        @if($reseller->logo_path)
                            <img src="{{ Storage::url($reseller->logo_path) }}"
                                class="h-16 w-16 object-cover rounded-full border border-gray-200">
                        @endif
                        <input type="file" name="logo"
                            class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                    </div>
                </div>

                <!-- Basics -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Company Name</label>
                    <input type="text" name="company_name" value="{{ old('company_name', $reseller->company_name) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Phone</label>
                    <input type="text" name="phone" value="{{ old('phone', $reseller->phone) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">GST Number</label>
                    <input type="text" name="gst_number" value="{{ old('gst_number', $reseller->gst_number) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <!-- Address -->
                <div class="col-span-1 md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700">Address</label>
                    <textarea name="address" rows="3"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">{{ old('address', $reseller->address) }}</textarea>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">City</label>
                    <input type="text" name="city" value="{{ old('city', $reseller->city) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">State</label>
                    <input type="text" name="state" value="{{ old('state', $reseller->state) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Pincode</label>
                    <input type="text" name="pincode" value="{{ old('pincode', $reseller->pincode) }}"
                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border p-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Country</label>
                    <input type="text" name="country" value="India" readonly
                        class="mt-1 block w-full bg-gray-50 border-gray-300 rounded-md shadow-sm text-gray-500 sm:text-sm border p-2 cursor-not-allowed">
                </div>
            </div>

            <div class="flex justify-between border-t pt-6">
                <a href="{{ route('password.request') }}"
                    class="text-sm text-indigo-600 hover:text-indigo-900 font-medium">Change Password?</a>
                <button type="submit"
                    class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700 transition">Update
                    Profile</button>
            </div>
        </form>
    </div>
@endsection