@extends('layouts.reseller')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="flex items-center justify-between mb-8">
            <div class="flex items-center gap-4">
                <a href="{{ route('reseller.orders.index') }}" class="p-2 bg-white rounded-lg border border-gray-200 text-gray-400 hover:text-indigo-600 transition-colors">
                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                </a>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Order #{{ $order->order_number }}</h1>
                    <p class="text-sm text-gray-500 mt-1">Placed on {{ $order->created_at->format('M d, Y') }}</p>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <span class="px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wide 
                    {{ $order->status == 'quotation_sent' ? 'bg-blue-100 text-blue-800' : 
                      ($order->status == 'quotation_accepted' ? 'bg-green-100 text-green-800' : 
                      ($order->status == 'completed' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-600')) }}">
                    {{ $order->status == 'quotation_sent' ? 'Quotation Received' : ucfirst(str_replace('_', ' ', $order->status)) }}
                </span>
                <a href="{{ route('reseller.orders.invoice', $order->id) }}" class="flex items-center gap-1.5 px-3 py-1.5 bg-white border border-gray-200 rounded-lg text-xs font-bold text-gray-700 hover:bg-gray-50 transition-colors">
                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    {{ $order->status === 'quotation_sent' ? 'Download Quotation' : 'Invoice' }}
                </a>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-50 bg-gray-50/50 flex justify-between items-center">
                <h3 class="text-sm font-bold uppercase tracking-widest text-gray-500">Items Ordered</h3>
                <span class="text-xs font-bold text-gray-400">{{ $order->items->count() }} Count</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-left text-xs font-bold text-gray-500 uppercase tracking-wider bg-white">
                            <th class="px-6 py-4">Product</th>
                            <th class="px-6 py-4 text-right">Price</th>
                            <th class="px-6 py-4 text-center">Qty</th>
                            <th class="px-6 py-4 text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @foreach($order->items as $item)
                        <tr>
                            <td class="px-6 py-4">
                                <span class="block font-bold text-gray-900">{{ $item->product->name }}</span>
                                @if(isset($item->options['discount_percentage']) && $item->options['discount_percentage'] > 0)
                                    <span class="block mt-1 text-xs font-bold text-green-600 bg-green-50 inline-block px-1.5 py-0.5 rounded">
                                        {{ $item->options['discount_percentage'] }}% OFF
                                    </span>
                                @endif
                                @if(isset($item->options['attributes']))
                                    <div class="flex gap-1 mt-1">
                                        @foreach($item->options['attributes'] as $attr)
                                            <span class="text-[10px] bg-gray-100 px-1.5 rounded text-gray-500 font-medium">{{ $attr['attribute'] }}: {{ $attr['value'] }}</span>
                                        @endforeach
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-right whitespace-nowrap">
                                @if(isset($item->options['discount_percentage']) && $item->options['discount_percentage'] > 0)
                                    <span class="block text-xs text-gray-400 line-through">₹{{ number_format($item->price / (1 - ($item->options['discount_percentage']/100)), 2) }}</span>
                                @endif
                                <span class="font-bold text-gray-700">₹{{ number_format($item->price, 2) }}</span>
                            </td>
                            <td class="px-6 py-4 text-center text-sm font-bold text-gray-900">{{ $item->quantity }}</td>
                            <td class="px-6 py-4 text-right font-bold text-gray-900">₹{{ number_format($item->total, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-6 bg-gray-50/30 border-t border-gray-50">
                <div class="flex justify-end">
                    <div class="w-full sm:w-1/3 space-y-2">
                        <div class="flex justify-between text-xs font-bold text-gray-500 uppercase">
                            <span>Subtotal</span>
                            <span class="text-gray-900">₹{{ number_format($order->subtotal, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-xs font-bold text-gray-500 uppercase">
                            <span>Shipping</span>
                            <span class="text-gray-900">₹{{ number_format($order->shipping_cost, 2) }}</span>
                        </div>
                        <div class="flex justify-between text-base font-bold text-gray-900 border-t border-gray-200 pt-3 mt-2">
                            <span>Total</span>
                            <span>₹{{ number_format($order->total, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if($order->status === 'quotation_sent')
            <div class="bg-indigo-50 border border-indigo-100 rounded-2xl p-6 flex flex-col sm:flex-row items-center justify-between gap-4">
                <div>
                    <h4 class="text-lg font-bold text-indigo-900">Quotation Pending Acceptance</h4>
                    <p class="text-sm text-indigo-700 mt-1">Please review the updated pricing above and accept the quotation to process your order.</p>
                </div>
                <form action="{{ route('reseller.orders.accept-quotation', $order->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="bg-indigo-600 text-white px-6 py-3 rounded-xl font-bold uppercase tracking-wider text-xs hover:bg-indigo-700 shadow-lg hover:shadow-indigo-200 transition-all flex items-center gap-2">
                        <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        Accept Quotation
                    </button>
                </form>
            </div>
        @elseif($order->status === 'quotation_accepted')
             <div class="bg-green-50 border border-green-100 rounded-2xl p-6 text-center sm:text-left">
                <h4 class="text-lg font-bold text-green-900 flex items-center gap-2 justify-center sm:justify-start">
                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Quotation Accepted
                </h4>
                <p class="text-sm text-green-700 mt-1">Your order is now being processed.</p>
            </div>
        @endif
    </div>
@endsection
