<div>
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order ID</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @forelse($orders as $order)
                    <tr>
                        <td class="px-4 py-3 text-sm font-medium text-indigo-600">
                            <a href="{{ route('reseller.orders.show', $order->id) }}">{{ $order->order_number }}</a>
                        </td>
                        <td class="px-4 py-3 text-sm text-gray-500">
                            {{ $order->created_at->format('M d, Y') }}
                        </td>
                        <td class="px-4 py-3 text-sm text-gray-900 font-bold">
                            ₹{{ number_format($order->total, 2) }}
                        </td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-0.5 inline-flex text-xs leading-4 font-semibold rounded-full uppercase text-center
                                                                    {{ $order->status == 'quotation_sent' ? 'bg-blue-100 text-blue-800' :
                ($order->status == 'quotation_accepted' ? 'bg-green-100 text-green-800' :
                    ($order->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">
                                {{ $order->status == 'quotation_sent' ? 'Quotation Received' : ucfirst(str_replace('_', ' ', $order->status)) }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <span
                                class="px-2.5 py-0.5 rounded-full text-xs font-bold bg-gray-100 text-gray-600 border border-gray-200">
                                {{ $order->items->count() }} Count
                            </span>
                        </td>
                        <td class="px-4 py-3 whitespace-nowrap text-right text-sm font-medium space-x-2">
                            <a href="{{ route('reseller.orders.show', $order->id) }}"
                                class="text-gray-600 hover:text-gray-900 border border-gray-300 px-3 py-1 rounded hover:bg-gray-50 transition">
                                View
                            </a>
                            <a href="{{ route('reseller.orders.invoice', $order->id) }}" target="_blank"
                                class="text-indigo-600 hover:text-indigo-900 border border-indigo-600 px-3 py-1 rounded hover:bg-indigo-50 transition">
                                {{ $order->status === 'quotation_sent' ? 'Quotation' : 'Invoice' }}
                            </a>
                        </td>
                    </tr>
            @empty
                <tr>
                    <td colspan="6" class="px-4 py-3 text-center text-gray-500">No orders found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>