@extends('layouts.reseller')

@section('content')
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">My Orders</h2>
            <p class="text-sm text-gray-500 mt-1">Manage and track your orders and quotations.</p>
        </div>
        <a href="{{ route('reseller.orders.create') }}"
            class="bg-indigo-600 text-white px-5 py-2.5 rounded-xl font-medium hover:bg-indigo-700 transition shadow-sm flex items-center gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"
                    clip-rule="evenodd" />
            </svg>
            Create New Order
        </a>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-8">
        @foreach(['all' => 'Total Orders', 'pending' => 'Pending', 'quotation_sent' => 'Quote Received', 'quotation_accepted' => 'Quote Accepted', 'completed' => 'Completed'] as $key => $label)
            <a href="{{ route('reseller.orders.index', ['status' => $key]) }}"
                class="bg-white p-4 rounded-xl border {{ request('status', 'all') == $key ? 'border-indigo-600 ring-1 ring-indigo-600 bg-indigo-50' : 'border-gray-200 hover:border-indigo-300' }} shadow-sm transition-all text-center group">
                <p
                    class="text-xs font-bold uppercase tracking-wider {{ request('status', 'all') == $key ? 'text-indigo-600' : 'text-gray-500 group-hover:text-indigo-500' }}">
                    {{ $label }}</p>
                <p class="text-2xl font-bold {{ request('status', 'all') == $key ? 'text-indigo-700' : 'text-gray-900' }} mt-1">
                    {{ $counts[$key] ?? 0 }}</p>
            </a>
        @endforeach
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
        <div class="border-b border-gray-200 px-6 py-4 flex items-center justify-between bg-gray-50/50">
            <h3 class="text-sm font-bold uppercase tracking-widest text-gray-600">Order List</h3>
            <span class="text-xs font-medium text-gray-500">Showing {{ $orders->count() }} of {{ $orders->total() }}
                results</span>
        </div>
        @include('reseller.orders.partials.table', ['orders' => $orders])
    </div>

    @if($orders->hasPages())
        <div class="mt-4 flex justify-center">
            {{ $orders->appends(request()->query())->links() }}
        </div>
    @endif

    @if(session('new_order_id'))
        <script>
            window.open("{{ route('reseller.orders.invoice', session('new_order_id')) }}", '_blank');
        </script>
    @endif
@endsection