@extends('layouts.reseller')

@section('content')
    <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-6" x-data="{ 
        viewMode: localStorage.getItem('resellerViewMode') || 'grid',
        showProductModal: false,
        activeProduct: null,
        openModal(product) {
            this.activeProduct = product;
            this.showProductModal = true;
        }
    }" x-init="$watch('viewMode', val => localStorage.setItem('resellerViewMode', val))">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">Create New Order</h2>

        <!-- View Toggle & Search -->
        <div>
            <div class="flex flex-col md:flex-row gap-4 mb-8 justify-between items-start md:items-center">
                <form action="{{ route('reseller.orders.create') }}" method="GET" class="flex-1 w-full" id="search_form">
                    <div class="flex gap-4">
                        <div class="flex-1 relative">
                            <input type="text" name="search" id="search_input" value="{{ request('search') }}"
                                placeholder="Search products..."
                                class="block w-full pl-4 pr-12 py-2 border border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                            <button type="button" onclick="startDictation()"
                                class="absolute right-2 top-2 text-gray-400 hover:text-indigo-600">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 11a7 7 0 01-7 7m0 0a7 7 0 01-7-7m7 7v4m0 0H8m4 0h4m-4-8a3 3 0 01-3-3V5a3 3 0 116 0v6a3 3 0 01-3 3z" />
                                </svg>
                            </button>
                        </div>
                        <div class="w-48 hidden md:block">
                            <select name="category" onchange="this.form.submit()"
                                class="block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                <option value="">All Categories</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-900">Search</button>
                    </div>
                </form>

                <!-- Toggle Buttons -->
                <div class="flex rounded-md shadow-sm bg-gray-100 p-1">
                    <button @click="viewMode = 'grid'" 
                        :class="{ 'bg-white shadow text-indigo-600': viewMode === 'grid', 'text-gray-500 hover:text-gray-700': viewMode !== 'grid' }"
                        class="px-3 py-2 rounded-md transition-all duration-200">
                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                        </svg>
                    </button>
                    <button @click="viewMode = 'list'"
                        :class="{ 'bg-white shadow text-indigo-600': viewMode === 'list', 'text-gray-500 hover:text-gray-700': viewMode !== 'list' }"
                        class="px-3 py-2 rounded-md transition-all duration-200">
                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>

            <form action="{{ route('reseller.orders.store') }}" method="POST" id="create-order-form">
                @csrf
                <div :class="viewMode === 'grid' ? 'grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6' : 'flex flex-col space-y-4'" class="mb-8">
                    @forelse($products as $product)
                        @php
                            // Image Logic
                            $imagePath = $product->variations->whereNotNull('image_path')->first()?->image_path 
                                        ?? $product->images->first()?->image_path;
                            
                            $imageUrl = 'https://placehold.co/400?text=No+Image';
                            if ($imagePath) {
                                // Strip any leading 'public/' or 'storage/' from the path from DB to avoid double prefixes
                                $cleanPath = str_replace(['public/', 'storage/'], '', $imagePath);
                                $imageUrl = \Illuminate\Support\Str::startsWith($imagePath, 'http') ? $imagePath : \Illuminate\Support\Facades\Storage::url($cleanPath);
                            }

                            // Prepare product object for JS
                            $productData = [
                                'name' => $product->name,
                                'category' => $product->category->name ?? 'Uncategorized',
                                'image_url' => $imageUrl,
                                'mrp' => number_format($product->mrp, 0),
                                'sp' => number_format($product->sp, 0),
                                'reseller_price' => number_format($product->reseller_price ?: ($product->sp ?: $product->mrp), 0),
                                'short_description' => $product->short_description ?? 'No short description available.',
                                'description' => $product->description ?? 'No details available.',
                                'unit' => $product->unit ?? 'N/A',
                                'country_of_origin' => $product->country_of_origin ?? 'N/A',
                                'stock' => $product->stock ?? 0,
                            ];
                        @endphp
                        <div class="group border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition bg-white"
                             :class="viewMode === 'list' ? 'flex flex-row h-40' : ''">
                            
                            <!-- Image -->
                            <div :class="viewMode === 'list' ? 'w-40 h-40' : 'aspect-w-1 aspect-h-1 w-full h-48'" class="overflow-hidden bg-gray-200 relative shrink-0">
                                <img src="{{ $imageUrl }}"
                                    alt="{{ $product->name }}"
                                    class="w-full h-full object-cover object-center group-hover:opacity-75 cursor-pointer"
                                    @click='openModal(@json($productData))'>
                                <!-- Reseller Price Badge -->
                                <div class="absolute top-2 right-2 bg-indigo-600 text-white text-xs font-bold px-2 py-1 rounded shadow">
                                    ₹{{ number_format($product->reseller_price ?: ($product->sp ?: $product->mrp), 0) }}
                                </div>
                            </div>

                            <!-- Content -->
                            <div class="p-4 flex-1 flex flex-col justify-between">
                                <div>
                                    <h3 class="text-sm font-medium text-gray-900 truncate cursor-pointer hover:text-indigo-600"
                                        @click='openModal(@json($productData))'>{{ $product->name }}</h3>
                                    <p class="text-xs text-gray-500 mt-1">{{ $product->category->name }}</p>
                                    
                                    <div class="mt-2 text-sm text-gray-500" :class="viewMode === 'list' ? 'hidden sm:block' : 'flex justify-between items-center'">
                                        <span class="mr-3">MRP: <span class="line-through">₹{{ number_format($product->mrp, 0) }}</span></span>
                                        <span>SP: ₹{{ number_format($product->sp, 0) }}</span>
                                    </div>
                                    
                                    <button type="button" 
                                            @click='openModal(@json($productData))'
                                            class="text-xs text-indigo-600 hover:text-indigo-800 font-bold mt-2 flex items-center gap-1">
                                        View Details
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>

                                <div class="mt-2" :class="viewMode === 'list' ? 'flex items-center justify-end' : ''">
                                    <label class="block text-xs font-medium text-gray-700 mr-2" :class="viewMode === 'list' ? '' : 'mb-1'">Quantity</label>
                                    <input type="hidden" name="items[{{ $loop->index }}][product_id]" value="{{ $product->id }}" class="product-id-input">
                                    <input type="number" name="items[{{ $loop->index }}][quantity]" min="0" value="0"
                                        :class="viewMode === 'list' ? 'w-24' : 'w-full'"
                                        class="block py-1.5 px-3 border border-gray-300 rounded text-sm focus:ring-indigo-500 focus:border-indigo-500 quantity-input">
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-span-full text-center py-12 text-gray-500">
                            No products found matching your search.
                        </div>
                    @endforelse
                </div>

            <div
                class="sticky bottom-0 bg-white border-t border-gray-200 p-4 -mx-6 -mb-6 flex justify-between items-center shadow-lg z-10">
                <span class="text-sm text-gray-500">Enter quantities above to order</span>
                <button type="submit"
                    class="bg-indigo-600 text-white px-8 py-3 rounded-full font-bold shadow-lg hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition transform hover:-translate-y-1">
                    Place Order
                </button>
            </div>

            <div class="mt-8 flex flex-col md:flex-row justify-between items-center pb-20">
                <div class="w-full md:w-auto overflow-x-auto">
                    {{ $products->links() }}
                </div>
                
                <div class="mt-4 md:mt-0 text-sm text-gray-600 font-medium bg-gray-50 px-4 py-2 rounded-full border border-gray-200">
                    <span class="mr-2 text-gray-500">Show per page:</span>
                    <a href="{{ request()->fullUrlWithQuery(['per_page' => 20]) }}" class="px-2 py-1 rounded {{ request('per_page', 20) == 20 ? 'bg-indigo-600 text-white shadow-sm' : 'hover:bg-gray-200 text-gray-700' }}">20</a>
                    <a href="{{ request()->fullUrlWithQuery(['per_page' => 50]) }}" class="px-2 py-1 rounded {{ request('per_page') == 50 ? 'bg-indigo-600 text-white shadow-sm' : 'hover:bg-gray-200 text-gray-700' }}">50</a>
                    <a href="{{ request()->fullUrlWithQuery(['per_page' => 100]) }}" class="px-2 py-1 rounded {{ request('per_page') == 100 ? 'bg-indigo-600 text-white shadow-sm' : 'hover:bg-gray-200 text-gray-700' }}">100</a>
                    <a href="{{ request()->fullUrlWithQuery(['per_page' => 'all']) }}" class="px-2 py-1 rounded {{ request('per_page') == 'all' ? 'bg-indigo-600 text-white shadow-sm' : 'hover:bg-gray-200 text-gray-700' }}">All</a>
                </div>
            </div>
        </form>
    </div>

    <!-- Product Details Modal -->
    <div x-show="showProductModal" 
        class="fixed inset-0 z-50 overflow-y-auto" 
        style="display: none;"
        x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0">
        
        <!-- Backdrop -->
        <div class="fixed inset-0 bg-black bg-opacity-50 transition-opacity" @click="showProductModal = false"></div>

        <!-- Modal Panel -->
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-2xl shadow-xl transform transition-all max-w-2xl w-full mx-auto relative overflow-hidden"
                 @click.stop>
                
                <!-- Close Button -->
                <button @click="showProductModal = false" class="absolute top-4 right-4 text-gray-400 hover:text-gray-600 z-10 p-2 bg-white/50 rounded-full hover:bg-white transition">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>

                <div class="flex flex-col md:flex-row">
                    <!-- Product Image -->
                    <div class="md:w-1/2 h-64 md:h-auto bg-gray-100 relative">
                        <img :src="activeProduct?.image_url" :alt="activeProduct?.name" class="w-full h-full object-cover">
                    </div>

                    <!-- Product Info -->
                    <div class="md:w-1/2 p-6 md:p-8 flex flex-col h-full max-h-[80vh] overflow-y-auto">
                        <div class="mb-4">
                            <span class="text-xs font-bold text-indigo-600 uppercase tracking-wide" x-text="activeProduct?.category"></span>
                            <h2 class="text-2xl font-bold text-gray-900 mt-1" x-text="activeProduct?.name"></h2>
                        </div>

                        <div class="flex items-baseline gap-4 mb-6 border-b border-gray-100 pb-4">
                            <p class="text-3xl font-bold text-indigo-600">₹<span x-text="activeProduct?.reseller_price"></span></p>
                            <p class="text-sm text-gray-500 line-through">₹<span x-text="activeProduct?.mrp"></span></p>
                            <span class="text-xs font-medium text-green-600 bg-green-50 px-2 py-1 rounded">Reseller Price</span>
                        </div>

                        <div class="space-y-4 text-sm text-gray-600 flex-1">
                            <div>
                                <h4 class="font-bold text-gray-900 mb-1">Short Description</h4>
                                <p x-text="activeProduct?.short_description"></p>
                            </div>
                            
                            <div>
                                <h4 class="font-bold text-gray-900 mb-1">Product Details</h4>
                                <p class="whitespace-pre-line" x-text="activeProduct?.description"></p>
                            </div>

                            <div class="grid grid-cols-2 gap-4 mt-4 pt-4 border-t border-gray-100">
                                <div>
                                    <span class="block text-xs text-gray-500">Unit</span>
                                    <span class="font-medium text-gray-900" x-text="activeProduct?.unit"></span>
                                </div>
                                <div>
                                    <span class="block text-xs text-gray-500">Country of Origin</span>
                                    <span class="font-medium text-gray-900" x-text="activeProduct?.country_of_origin"></span>
                                </div>
                                <div>
                                    <span class="block text-xs text-gray-500">Stock Status</span>
                                    <span class="font-medium" :class="activeProduct?.stock > 0 ? 'text-green-600' : 'text-red-600'" x-text="activeProduct?.stock > 0 ? 'In Stock' : 'Out of Stock'"></span>
                                </div>
                            </div>
                        </div>

                        <div class="mt-8 pt-4 border-t border-gray-100">
                            <button @click="showProductModal = false" class="w-full bg-gray-900 text-white py-3 rounded-xl font-bold hover:bg-black transition">
                                Close Details
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script>
        document.getElementById('create-order-form').addEventListener('submit', function(e) {
            const quantities = this.querySelectorAll('.quantity-input');
            let hasSelection = false;

            // First, reset any previously disabled inputs (in case of cached BF cache or previous partial submit)
            // Actually, we'll just process them.
            
            // To be safe, we gather the IDs of inputs we want to SUBMIT.
            // But modifying 'disabled' prop is the easiest way to prevent submission.
            
            quantities.forEach(qty => {
                const hiddenId = qty.previousElementSibling; 
                if (parseInt(qty.value) > 0) {
                    hasSelection = true;
                    qty.disabled = false;
                    if(hiddenId) hiddenId.disabled = false;
                } else {
                    qty.disabled = true;
                    if(hiddenId) hiddenId.disabled = true;
                }
            });

            if (!hasSelection) {
                e.preventDefault();
                alert('Please select at least one product to place an order.');
                // Re-enable inputs so the user isn't stuck with a disabled form
                quantities.forEach(qty => {
                    qty.disabled = false;
                    const hiddenId = qty.previousElementSibling;
                    if(hiddenId) hiddenId.disabled = false;
                });
                return;
            }
            
            // If proceeding, inputs with 0 are disabled and won't be sent.
            // Note: If the user navigates back, browsers might restore state.
            // Ideally we re-enable after a short timeout just in case the submit is via ajax or they hit back.
            // But for a standard POST redirect, this is fine.
            setTimeout(() => {
                 quantities.forEach(qty => {
                    qty.disabled = false;
                    const hiddenId = qty.previousElementSibling;
                    if(hiddenId) hiddenId.disabled = false;
                });
            }, 1000);
        });

        function startDictation() {
            if (window.hasOwnProperty('webkitSpeechRecognition')) {
                var recognition = new webkitSpeechRecognition();

                recognition.continuous = false;
                recognition.interimResults = false;
                recognition.lang = "en-US";
                recognition.start();

                recognition.onresult = function (e) {
                    document.getElementById('search_input').value = e.results[0][0].transcript;
                    recognition.stop();
                    document.getElementById('search_form').submit();
                };

                recognition.onerror = function (e) {
                    console.log("Speech recognition error", e);
                    recognition.stop();
                }
            } else {
                alert("Voice search is not supported in this browser.");
            }
        }
    </script>
@endsection