@extends('layouts.reseller')

@section('content')
    <div class="mb-8 flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Dashboard</h2>
            <p class="text-gray-500 text-sm">Welcome back, {{ Auth::user()->name }}!</p>
        </div>
        <div class="flex gap-3">
            <a href="{{ route('reseller.orders.create') }}"
                class="bg-indigo-600 text-white px-5 py-2.5 rounded-xl font-bold text-sm hover:bg-indigo-700 transition shadow-lg shadow-indigo-200 flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd"
                        d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"
                        clip-rule="evenodd" />
                </svg>
                New Order
            </a>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Total Orders -->
        <div
            class="bg-gradient-to-br from-indigo-600 to-indigo-900 rounded-2xl p-6 text-white shadow-xl shadow-indigo-200 transform transition hover:-translate-y-1 relative overflow-hidden">
            <div class="relative z-10 flex justify-between items-start">
                <div>
                    <p class="text-indigo-100 text-xs font-bold uppercase tracking-wider">Total Orders</p>
                    <h3 class="text-3xl font-extrabold mt-1">{{ \App\Models\Order::where('user_id', Auth::id())->count() }}
                    </h3>
                </div>
                <div class="bg-white/20 p-2 rounded-lg backdrop-blur-sm">
                    <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                </div>
            </div>
            <div class="relative z-10 mt-4 text-xs font-medium text-indigo-100 bg-white/10 inline-block px-2 py-1 rounded">
                Lifetime Volume
            </div>
            <!-- Decor -->
            <div class="absolute right-0 bottom-0 opacity-10 transform translate-y-1/3 translate-x-1/3">
                <svg class="w-32 h-32" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                </svg>
            </div>
        </div>

        <!-- Pending -->
        <div
            class="bg-gradient-to-br from-orange-500 to-red-600 rounded-2xl p-6 text-white shadow-xl shadow-orange-200 transform transition hover:-translate-y-1 relative overflow-hidden">
            <div class="relative z-10 flex justify-between items-start">
                <div>
                    <p class="text-orange-100 text-xs font-bold uppercase tracking-wider">Pending Review</p>
                    <h3 class="text-3xl font-extrabold mt-1">
                        {{ \App\Models\Order::where('user_id', Auth::id())->where('status', 'pending')->count() }}
                    </h3>
                </div>
                <div class="bg-white/20 p-2 rounded-lg backdrop-blur-sm">
                    <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
            </div>
            <div class="relative z-10 mt-4 text-xs font-medium text-orange-100 bg-white/10 inline-block px-2 py-1 rounded">
                Awaiting Quotation
            </div>
            <div class="absolute right-0 bottom-0 opacity-10 transform translate-y-1/3 translate-x-1/3">
                <svg class="w-32 h-32" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
        </div>

        <!-- Quotation Received -->
        <div
            class="bg-gradient-to-br from-blue-600 to-blue-900 rounded-2xl p-6 text-white shadow-xl shadow-blue-200 transform transition hover:-translate-y-1 relative overflow-hidden">
            <div class="relative z-10 flex justify-between items-start">
                <div>
                    <p class="text-blue-100 text-xs font-bold uppercase tracking-wider">Quotes Received</p>
                    <h3 class="text-3xl font-extrabold mt-1">
                        {{ \App\Models\Order::where('user_id', Auth::id())->where('status', 'quotation_sent')->count() }}
                    </h3>
                </div>
                <div class="bg-white/20 p-2 rounded-lg backdrop-blur-sm">
                    <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                </div>
            </div>
            <div class="relative z-10 mt-4 text-xs font-medium text-blue-100 bg-white/10 inline-block px-2 py-1 rounded">
                Action Required
            </div>
            <div class="absolute right-0 bottom-0 opacity-10 transform translate-y-1/3 translate-x-1/3">
                <svg class="w-32 h-32" fill="currentColor" viewBox="0 0 20 20">
                    <path
                        d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
            </div>
        </div>

        <!-- Completed -->
        <div
            class="bg-gradient-to-br from-emerald-600 to-emerald-900 rounded-2xl p-6 text-white shadow-xl shadow-emerald-200 transform transition hover:-translate-y-1 relative overflow-hidden">
            <div class="relative z-10 flex justify-between items-start">
                <div>
                    <p class="text-emerald-100 text-xs font-bold uppercase tracking-wider">Completed</p>
                    <h3 class="text-3xl font-extrabold mt-1">
                        {{ \App\Models\Order::where('user_id', Auth::id())->where('status', 'completed')->count() }}
                    </h3>
                </div>
                <div class="bg-white/20 p-2 rounded-lg backdrop-blur-sm">
                    <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
            </div>
            <div class="relative z-10 mt-4 text-xs font-medium text-emerald-100 bg-white/10 inline-block px-2 py-1 rounded">
                Successfully Delivered
            </div>
            <div class="absolute right-0 bottom-0 opacity-10 transform translate-y-1/3 translate-x-1/3">
                <svg class="w-32 h-32" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
        </div>
    </div>

    <!-- Quick Actions & Help Grid -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Update Profile Card -->
        <a href="{{ route('reseller.profile') }}"
            class="bg-white rounded-2xl p-6 shadow-sm border border-gray-200 hover:shadow-md transition group flex flex-col justify-between">
            <div class="flex items-start justify-between mb-4">
                <div
                    class="bg-indigo-100 text-indigo-600 p-3 rounded-xl group-hover:bg-indigo-600 group-hover:text-white transition-colors">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                </div>
                <svg class="w-5 h-5 text-gray-300 group-hover:text-indigo-600 transition-colors" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </div>
            <div>
                <h3 class="font-bold text-gray-900 text-lg">Update Profile</h3>
                <p class="text-sm text-gray-500 mt-1">Manage address & details</p>
            </div>
        </a>

        <!-- Pending Quotes Card -->
        <a href="{{ route('reseller.orders.index', ['status' => 'quotation_sent']) }}"
            class="bg-white rounded-2xl p-6 shadow-sm border border-gray-200 hover:shadow-md transition group flex flex-col justify-between">
            <div class="flex items-start justify-between mb-4">
                <div
                    class="bg-blue-100 text-blue-600 p-3 rounded-xl group-hover:bg-blue-600 group-hover:text-white transition-colors">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                </div>
                <svg class="w-5 h-5 text-gray-300 group-hover:text-blue-600 transition-colors" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </div>
            <div>
                <h3 class="font-bold text-gray-900 text-lg">Pending Quotes</h3>
                <p class="text-sm text-gray-500 mt-1">Review received quotations</p>
            </div>
        </a>

        <!-- Help Card -->
        <div
            class="bg-gray-900 rounded-2xl p-6 text-white shadow-lg relative overflow-hidden flex flex-col justify-between">
            <div class="absolute -right-6 -top-6 w-24 h-24 bg-white/10 rounded-full blur-2xl"></div>

            @php
                $admin = \App\Models\User::whereHas('roles', function ($q) {
                    $q->where('name', 'admin'); })->first() ?? \App\Models\User::find(1);
                $adminName = $admin->name ?? 'Support';
                $adminEmail = $admin->email ?? 'support@lugani.com';
                $adminPhone = $admin->whatsapp_number ?? '+91 98765 43210';
            @endphp

            <div class="relative z-10">
                <div class="flex justify-between items-start mb-4">
                    <h3 class="text-lg font-bold">Need Help?</h3>
                    @if($admin)
                        <div
                            class="h-8 w-8 rounded-full bg-white/10 flex items-center justify-center text-xs font-bold shrink-0">
                            {{ substr($adminName, 0, 1) }}
                        </div>
                    @endif
                </div>
                <p class="text-gray-300 text-sm leading-relaxed mb-4">Contact your account manager for assistance.</p>

                <div class="flex items-center gap-3 mb-4">
                    <div>
                        <p class="text-sm font-bold text-white">{{ $adminName }}</p>
                        <p class="text-xs text-indigo-400">{{ $adminEmail }}</p>
                    </div>
                </div>
            </div>

            <div class="relative z-10 mt-auto pt-4 border-t border-white/10">
                <a href="tel:{{ $adminPhone }}" class="group block">
                    <span
                        class="text-sm font-bold text-gray-900 bg-white px-4 py-2 rounded-lg flex items-center justify-center gap-2 w-full transition transform group-hover:-translate-y-0.5">
                        <svg class="w-4 h-4 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                        </svg>
                        Call Support
                    </span>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-200 overflow-hidden mb-8">
        <div class="px-6 py-5 border-b border-gray-100 bg-gray-50/50 flex justify-between items-center">
            <h3 class="font-bold text-gray-800">Recent Activity</h3>
            <a href="{{ route('reseller.orders.index') }}"
                class="text-xs font-bold text-indigo-600 hover:text-indigo-700 uppercase tracking-wide">View All</a>
        </div>
        @include('reseller.orders.partials.table', ['orders' => \App\Models\Order::where('user_id', Auth::id())->latest()->take(5)->get()])
    </div>
@endsection