<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Invoice {{ $order->order_number }}</title>
    <style>
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            color: #333;
            font-size: 14px;
            line-height: 1.6;
        }

        .container {
            width: 100%;
            margin: 0 auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        th {
            background-color: #f8f9fa;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
        }

        .header {
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }

        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }

        .invoice-details {
            text-align: right;
        }

        .address-section {
            margin-bottom: 30px;
            display: table;
            width: 100%;
        }

        .address-box {
            display: table-cell;
            width: 48%;
            vertical-align: top;
        }

        .total-section {
            width: 100%;
            display: table;
        }

        .total-box {
            display: table-cell;
            width: 40%;
            text-align: right;
            padding-left: 60%;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
        }

        .total-final {
            font-size: 18px;
            font-weight: bold;
            border-top: 2px solid #333;
            margin-top: 10px;
            padding-top: 10px;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #eee;
            padding-top: 20px;
        }

        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            text-transform: uppercase;
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <table>
                <tr>
                    <td style="border:none;">
                        <div class="company-name">Hair Niche By Shelly</div>
                        <div>Because love is in the hair</div>
                    </td>
                    <td style="border:none; text-align: right;">
                        <div style="font-size: 20px; font-weight: bold; color: #555;">
                            {{ $order->status === 'quotation_sent' ? 'QUOTATION' : 'INVOICE' }}
                        </div>
                        <div style="margin-top: 5px;">#{{ $order->order_number }}</div>
                        <div>Date: {{ $order->created_at->format('M d, Y') }}</div>
                        <div style="margin-top: 5px;">
                            Status: <span style="text-transform: uppercase;">{{ $order->payment_status }}</span>
                        </div>
                    </td>
                </tr>
            </table>
        </div>

        <div class="address-section">
            <div class="address-box">
                <h3 style="border-bottom: 1px solid #ccc; padding-bottom: 5px; margin-bottom: 10px;">Billed To</h3>
                <strong>{{ $order->name }}</strong><br>
                {{ $order->email }}<br>
                {{ $order->phone }}<br><br>
                @if($order->billingAddress)
                    {{ $order->billingAddress->address_line1 }}<br>
                    @if($order->billingAddress->address_line2) {{ $order->billingAddress->address_line2 }}<br> @endif
                    {{ $order->billingAddress->city }}, {{ $order->billingAddress->state }} -
                    {{ $order->billingAddress->postal_code }}<br>
                    {{ $order->billingAddress->country }}
                @endif
            </div>
            <div style="display: table-cell; width: 4%;"></div>
            <div class="address-box">
                <h3 style="border-bottom: 1px solid #ccc; padding-bottom: 5px; margin-bottom: 10px;">Shipped To</h3>
                <strong>{{ $order->shippingAddress->name ?? $order->name }}</strong><br>
                {{ $order->shippingAddress->phone ?? $order->phone }}<br><br>
                @if($order->shippingAddress)
                    {{ $order->shippingAddress->address_line1 }}<br>
                    @if($order->shippingAddress->address_line2) {{ $order->shippingAddress->address_line2 }}<br> @endif
                    {{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }} -
                    {{ $order->shippingAddress->postal_code }}<br>
                    {{ $order->shippingAddress->country }}
                @endif
            </div>
        </div>

        <h3>Order Items</h3>
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th class="text-right">Price</th>
                    <th class="text-center">Qty</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->items as $item)
                    <tr>
                        <td>
                            <div>{{ $item->product->name }}</div>
                            @if($item->variation)
                                <div style="font-size: 11px; color: #666; margin-top: 2px;">
                                    @foreach($item->variation->options as $option)
                                        {{ $option->attribute_value }}@if(!$loop->last) / @endif
                                    @endforeach
                                </div>
                            @endif
                        </td>
                        <td class="text-right">₹{{ number_format($item->price, 2) }}</td>
                        <td class="text-center">{{ $item->quantity }}</td>
                        <td class="text-right">₹{{ number_format($item->total, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="total-section">
            <table style="width: 40%; margin-left: auto;">
                <tr>
                    <td style="border: none; padding: 5px;" class="text-right">Subtotal:</td>
                    <td style="border: none; padding: 5px;" class="text-right">₹{{ number_format($order->subtotal, 2) }}
                    </td>
                </tr>
                @if($order->discount > 0)
                    <tr>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">Discount:</td>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">
                            -₹{{ number_format($order->discount, 2) }}</td>
                    </tr>
                @endif
                @if($order->gift_card_discount > 0)
                    <tr>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">Gift Card:</td>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">
                            -₹{{ number_format($order->gift_card_discount, 2) }}</td>
                    </tr>
                @endif
                @if($order->points_discount > 0)
                    <tr>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">Points Redeemed
                            ({{ $order->points_redeemed }}):</td>
                        <td style="border: none; padding: 5px; color: green;" class="text-right">
                            -₹{{ number_format($order->points_discount, 2) }}</td>
                    </tr>
                @endif
                <tr>
                    <td style="border: none; padding: 5px;" class="text-right">Shipping:</td>
                    <td style="border: none; padding: 5px;" class="text-right">
                        @if($order->shipping_cost > 0)
                            ₹{{ number_format($order->shipping_cost, 2) }}
                        @else
                            Free
                        @endif
                    </td>
                </tr>
                <tr>
                    <td style="border-top: 2px solid #333; padding: 10px 5px; font-weight: bold; font-size: 16px;"
                        class="text-right">Total:</td>
                    <td style="border-top: 2px solid #333; padding: 10px 5px; font-weight: bold; font-size: 16px;"
                        class="text-right">₹{{ number_format($order->total, 2) }}</td>
                </tr>
            </table>
        </div>

        <div class="footer">
            <p>Thank you for your business!</p>
            <p>For any queries, please contact us at support@lugani.com</p>
        </div>
    </div>
</body>

</html>