<div x-data="chatbotWidget()" x-init="initBot()" class="fixed z-[100] font-sans" style="bottom: 24px; right: 24px;"
    x-show="settings.is_active" x-cloak>
    <!-- Toggle Button -->
    <button @click="open = !open"
        class="w-14 h-14 rounded-full shadow-2xl flex items-center justify-center text-white transition-all transform hover:scale-110 active:scale-95 group relative z-50"
        :style="`background-color: ${settings.color_scheme || '#9B2D69'}`">
        <span x-show="!open" class="group-hover:rotate-12 transition-transform duration-300">
            <!-- Chat Icon -->
            <svg class="w-7 h-7" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
            </svg>
        </span>
        <span x-show="open" x-cloak>
            <!-- Close Icon -->
            <svg class="w-7 h-7" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
            </svg>
        </span>
    </button>

    <!-- Chat Window -->
    <div x-show="open" x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0 translate-y-10 scale-95"
        x-transition:enter-end="opacity-100 translate-y-0 scale-100"
        x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100 translate-y-0 scale-100"
        x-transition:leave-end="opacity-0 translate-y-10 scale-95"
        class="fixed bg-white rounded-2xl shadow-2xl overflow-hidden border border-gray-100 flex flex-col h-[550px] max-h-[80vh] z-[101]"
        style="bottom: 100px; right: 24px; width: 380px; max-width: 90vw;">

        <!-- Header -->
        <div class="px-6 py-4 flex justify-between items-center text-white shadow-md relative z-10"
            :style="`background-color: ${settings.color_scheme || '#9B2D69'}`">
            <div class="flex items-center gap-3">
                <div class="relative">
                    <div class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <div
                        class="absolute bottom-0 right-0 w-2.5 h-2.5 bg-green-400 rounded-full border-2 border-white animate-pulse">
                    </div>
                </div>
                <div>
                    <h3 class="font-bold text-lg leading-tight" x-text="settings.name || 'Support Bot'"></h3>
                    <p class="text-[10px] opacity-90 uppercase tracking-wider font-medium">Online & Ready</p>
                </div>
            </div>
            <button @click="open = false"
                class="text-white/80 hover:text-white transition-colors p-1 hover:bg-white/10 rounded-lg">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                </svg>
            </button>
        </div>

        <!-- Messages Area -->
        <div class="flex-1 overflow-y-auto p-4 space-y-4 bg-gray-50/50" id="chat-messages" x-ref="chatMessages">
            <!-- Welcome Message Template -->
            <template x-for="(msg, index) in messages" :key="index">
                <div class="flex flex-col gap-1" :class="msg.sender === 'user' ? 'items-end' : 'items-start'">
                    <div class="max-w-[85%] rounded-2xl px-5 py-3 text-sm shadow-sm relative group"
                        :class="msg.sender === 'user' ? 'text-white rounded-br-none' : 'bg-white text-gray-800 border border-gray-100 rounded-bl-none'"
                        :style="msg.sender === 'user' ? `background-color: ${settings.color_scheme || '#9B2D69'}` : ''">
                        <p x-html="msg.text" class="leading-relaxed whitespace-pre-wrap break-words"></p>
                    </div>
                    <span class="text-[10px] text-gray-400 px-1" x-text="msg.time"></span>
                </div>
            </template>

            <!-- Typing Indicator -->
            <div x-show="loading" class="flex justify-start w-full"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 translate-y-2">
                <div
                    class="bg-white rounded-2xl rounded-bl-none px-4 py-3 border border-gray-100 shadow-sm flex items-center gap-1.5 w-fit">
                    <span class="w-1.5 h-1.5 bg-gray-400 rounded-full animate-bounce"></span>
                    <span class="w-1.5 h-1.5 bg-gray-400 rounded-full animate-bounce delay-75"></span>
                    <span class="w-1.5 h-1.5 bg-gray-400 rounded-full animate-bounce delay-150"></span>
                </div>
            </div>
        </div>

        <!-- Input Area -->
        <div class="p-4 bg-white border-t border-gray-100">
            <form @submit.prevent="sendMessage" class="flex items-center gap-2 relative">
                <input type="text" x-model="inputValue" placeholder="Type your message..."
                    class="w-full border border-gray-200 bg-gray-50 rounded-full pl-10 pr-12 py-3 text-sm focus:ring-2 focus:ring-offset-2 transition-all placeholder-gray-400 font-medium text-gray-700 focus:bg-white focus:border-transparent outline-none shadow-sm"
                    :style="`--tw-ring-color: ${settings.color_scheme || '#9B2D69'}`" :disabled="loading">

                <button type="submit"
                    class="absolute right-1.5 top-1.5 bottom-1.5 w-10 rounded-full text-white shadow-md transform transition-all disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center hover:scale-105 active:scale-95"
                    :style="`background-color: ${settings.color_scheme || '#9B2D69'}`"
                    :disabled="!inputValue.trim() || loading">
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                    </svg>
                </button>
            </form>
            <div class="flex justify-center mt-3">
                <span class="text-[10px] font-bold text-gray-300 uppercase tracking-widest flex items-center gap-1">
                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                    Powered by AI Assistant
                </span>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('chatbotWidget', () => ({
            open: false,
            loading: false,
            inputValue: '',
            settings: {
                name: 'Support Bot',
                color_scheme: '#9B2D69',
                welcome_message: '',
                is_active: false // Default to false until loaded
            },
            messages: [],

            async initBot() {
                try {
                    const response = await fetch("{{ route('chatbot.init') }}");
                    if (!response.ok) throw new Error('Network response was not ok');
                    const data = await response.json();
                    this.settings = data.settings;

                    // Only push welcome message if messages are empty
                    if (this.messages.length === 0 && this.settings.welcome_message) {
                        this.pushMessage(this.settings.welcome_message, 'bot');
                    }
                } catch (error) {
                    console.error('Bot init failed', error);
                    // Fallback settings if fetch fails
                    if (this.messages.length === 0) {
                        this.pushMessage("Hello! How can I help you today?", 'bot');
                    }
                }
            },

            async sendMessage() {
                const text = this.inputValue.trim();
                if (!text) return;

                this.pushMessage(text, 'user');
                this.inputValue = '';
                this.loading = true;
                this.scrollToBottom();

                try {
                    // Simulate network delay for realism if on local
                    // await new Promise(r => setTimeout(r, 600));

                    const response = await fetch("{{ route('chatbot.message') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ message: text })
                    });

                    if (!response.ok) throw new Error('Network response was not ok');

                    const data = await response.json();

                    this.loading = false;
                    this.pushMessage(data.reply, 'bot');
                } catch (error) {
                    console.error('Message failed', error);
                    this.loading = false;
                    this.pushMessage("I'm having trouble connecting right now. Please try again later.", 'bot');
                }
            },

            pushMessage(text, sender) {
                this.messages.push({
                    text: text,
                    sender: sender,
                    time: new Date().toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' })
                });
                this.scrollToBottom();
            },

            scrollToBottom() {
                this.$nextTick(() => {
                    const chatMessages = this.$refs.chatMessages;
                    if (chatMessages) {
                        chatMessages.scrollTop = chatMessages.scrollHeight;
                    }
                });
            }
        }));
    });
</script>