@extends('layouts.shop')

@section('title', $page->meta_title ?? $page->title)
@section('meta_description', $page->meta_description ?? '')

@section('meta_keywords', $page->meta_keywords ?? '')

@push('meta')
    @if($page->is_nofollow)
        <meta name="robots" content="nofollow">
    @endif
@endpush

@push('schema_markup')
    @if($page->schema_markup)
        {!! $page->schema_markup !!}
    @endif
@endpush

@section('content')
    <div class="bg-gray-50 min-h-screen py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                <div class="p-8 sm:p-12">
                    <h1 class="text-3xl font-bold text-[#9B2D69] mb-6">{{ $page->title }}</h1>
                    <div class="prose prose-lg prose-pink max-w-none text-gray-600">
                        {!! $page->content !!}
                    </div>
                </div>
                <div class="bg-gray-50 px-8 py-4 text-xs text-gray-500 text-center border-t border-gray-100">
                    Last updated: {{ $page->updated_at->format('F j, Y') }}
                </div>
            </div>
        </div>
    </div>
@endsection