@extends('layouts.shop')

@section('title', 'Privacy Policy - Hair Niche By Shelly')

@section('content')
    <div class="max-w-4xl mx-auto px-4 py-16 sm:px-6 lg:px-8">
        <h1 class="text-4xl font-bold text-[#9B2D69] mb-8 text-center uppercase tracking-wide">Privacy Policy</h1>

        <div class="prose prose-lg mx-auto text-gray-600 space-y-6">
            <p>Lugani Herbs takes data privacy and security seriously and ensures compliance with relevant regulations. By
                using the platform, users agree to the terms of the Privacy Policy, Terms of Use, and Indian laws.</p>

            <section>
                <h2 class="text-xl font-bold text-gray-800 mb-3">Information Collection</h2>
                <p>We collect the following information provided during registration or transactions:</p>
                <ul class="list-disc pl-5">
                    <li>Email address</li>
                    <li>Delivery address</li>
                    <li>Name and Phone number</li>
                    <li>Payment instrument details (excluding CVV)</li>
                </ul>
            </section>

            <section>
                <h2 class="text-xl font-bold text-gray-800 mb-3">Tracking & Cookies</h2>
                <p>We collect behavioral data, preferences, browser information, and IP addresses to understand demographics
                    and user behavior. We use "cookies" to analyze web page flow, measure promotional effectiveness, and
                    ensure trust and safety.</p>
            </section>

            <section>
                <h2 class="text-xl font-bold text-gray-800 mb-3">Usage of Information</h2>
                <p>Your personal information is used to:</p>
                <ul class="list-disc pl-5">
                    <li>Provide requested services</li>
                    <li>Facilitate order fulfillment and troubleshoot issues</li>
                    <li>Detect and protect against error, fraud, and other criminal activity</li>
                    <li>Market to you (with the ability to opt-out)</li>
                </ul>
            </section>

            <section>
                <h2 class="text-xl font-bold text-gray-800 mb-3">Third-Party Disclosures</h2>
                <p>With your consent, we may access SMS, contacts, location, and device information for KYC and eligibility
                    checks. We are not responsible for the content or accuracy of linked third-party websites.</p>
            </section>
        </div>
    </div>
@endsection