@extends('layouts.shop')

@section('title', 'Cancellation Policy - Hair Niche By Shelly')

@section('content')
    <div class="max-w-4xl mx-auto px-4 py-16 sm:px-6 lg:px-8">
        <h1 class="text-4xl font-bold text-[#9B2D69] mb-8 text-center uppercase tracking-wide">Cancellation Policy</h1>

        <div class="prose prose-lg mx-auto text-gray-600 space-y-8">
            <section>
                <h2 class="text-2xl font-bold text-gray-800 mb-4">Cancellation before shipment</h2>
                <p>
                    If the order or the item(s) in the order, that you want to cancel have not been shipped yet, you can
                    cancel that order by login into your account. Then follow these steps:
                    <span class="font-medium text-gray-900">My Orders Tab > go to the particular order > Click on OrderID of
                        that order > order detail page > click cancel order</span>.
                    In such cases, the order will be cancelled, and the money will be refunded to you within 24-48 business
                    hours after the cancellation request is duly processed by us.
                </p>
            </section>

            <section>
                <h2 class="text-2xl font-bold text-gray-800 mb-4">Cancellation after shipment</h2>
                <p>
                    In case the cancellation request is made after the shipment has already been dispatched or if it is
                    being returned, we process the refund once the products have been received and verified at our
                    warehouse.
                </p>
                <ul class="list-disc pl-5 mt-4 space-y-2">
                    <li>
                        <strong>For cash on delivery transactions:</strong> We will initiate a bank transfer against the
                        refund amount using the billing details shared by you. This process will be completed within 48-72
                        business hours of us receiving the products back and to the same bank account added in your user
                        account. It will take an additional 2-3 business days for the amount to reflect in your account.
                    </li>
                    <li>
                        <strong>For payments done through credit/debit cards or net banking:</strong> The refund will be
                        processed to the same account from which the payment was made within 48-72 business hours of us
                        receiving the products back. It may take 2-3 additional business days for the amount to reflect in
                        your account.
                    </li>
                </ul>
            </section>
        </div>
    </div>
@endsection