@extends('layouts.shop')
@push('schema_markup')
    @php
        $aboutSchema = \App\Models\SeoSetting::where('page_name', 'about')->value('schema_markup');
    @endphp
    @if($aboutSchema)
        {!! $aboutSchema !!}
    @endif
@endpush

@section('content')
    <div class="max-w-4xl mx-auto px-4 py-16 sm:px-6 lg:px-8">
        <h1 class="text-4xl font-bold text-[#9B2D69] mb-8 text-center uppercase tracking-wide">About Us</h1>

        <div class="prose prose-lg mx-auto text-gray-600">
            <p class="lead text-xl text-gray-800 font-medium mb-6">
                Welcome to Lugani Herbs, your trusted source for premium quality herbal extracts, dry fruits, raw herbs, and
                spices.
            </p>

            <p>
                At Lugani Herbs, we are dedicated to providing the finest natural products sourced directly from the best
                origins.
                As a leading wholesaler and retailer, we take pride in offering a wide range of authentic herbs and spices
                that add flavor,
                aroma, and health benefits to your life.
            </p>

            <h3 class="text-2xl font-bold text-gray-800 mt-8 mb-4">Our Mission</h3>
            <p>
                Our mission is to bring the purity of nature to your doorstep. We believe in the power of natural
                ingredients
                to enhance well-being and culinary experiences. Whether you are looking for rare medicinal herbs,
                premium dry fruits, or aromatic spices, we ensure that every product meets our rigorous standards of quality
                and freshness.
            </p>

            <h3 class="text-2xl font-bold text-gray-800 mt-8 mb-4">Why Choose Us?</h3>
            <ul class="list-disc pl-5 space-y-2">
                <li><strong>Quality Assurance:</strong> We rigorously test and select only the best products.</li>
                <li><strong>Wide Selection:</strong> From everyday spices to exotic herbs, we have a diverse inventory.</li>
                <li><strong>Customer Focus:</strong> We are committed to excellent service and satisfaction.</li>
            </ul>

            <p class="mt-8">
                Thank you for choosing Lugani Herbs. We look forward to serving you with the best nature has to offer.
            </p>
        </div>
    </div>
@endsection