<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reseller Dashboard - Hair Niche By Shelly</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <style>
        [x-cloak] {
            display: none !important;
        }

        body {
            font-family: 'Urbanist', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50">
    <div class="min-h-screen flex flex-col">
        <!-- Header -->
        <header class="bg-white shadow-sm z-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center">
                    <a href="{{ route('reseller.dashboard') }}"
                        class="text-2xl font-bold text-gray-900 tracking-tight">LUGANI <span
                            class="text-indigo-600">RESELLER</span></a>
                </div>
                <div class="flex items-center space-x-6">
                    <nav class="hidden md:flex space-x-6">
                        <a href="{{ route('reseller.dashboard') }}"
                            class="text-sm font-medium {{ request()->routeIs('reseller.dashboard') ? 'text-indigo-600' : 'text-gray-500 hover:text-gray-900' }}">Dashboard</a>
                        <a href="{{ route('reseller.orders.index') }}"
                            class="text-sm font-medium {{ request()->routeIs('reseller.orders.index') ? 'text-indigo-600' : 'text-gray-500 hover:text-gray-900' }}">My
                            Orders</a>
                        <a href="{{ route('reseller.orders.create') }}"
                            class="text-sm font-medium {{ request()->routeIs('reseller.orders.create') ? 'text-indigo-600' : 'text-gray-500 hover:text-gray-900' }}">Create
                            Order</a>
                        <a href="{{ route('reseller.profile') }}"
                            class="text-sm font-medium {{ request()->routeIs('reseller.profile') ? 'text-indigo-600' : 'text-gray-500 hover:text-gray-900' }}">Profile</a>
                    </nav>

                    <div class="h-6 w-px bg-gray-200 hidden md:block"></div>

                    <div class="flex items-center space-x-4">
                        <span class="text-sm text-gray-900 font-semibold">{{ Auth::user()->name }}</span>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit"
                                class="text-sm text-red-600 hover:text-red-800 font-medium whitespace-nowrap">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
        </header>

        <div class="flex flex-1">
            <!-- Main Content -->
            <main class="flex-1 p-8 max-w-7xl mx-auto w-full">
                @if(session('success'))
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded text-green-700">
                        {{ session('success') }}
                    </div>
                @endif
                @if(session('error'))
                    <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded text-red-700">
                        {{ session('error') }}
                    </div>
                @endif
                @yield('content')
            </main>
        </div>
    </div>
</body>

</html>