<!DOCTYPE html>
<html>

<head>
    <style>
        body {
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            background-color: #f9fafb;
            padding: 40px 0;
            margin: 0;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .header {
            background: #4f46e5;
            padding: 30px;
            text-align: center;
            color: white;
        }

        .content {
            padding: 40px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 14px;
        }

        .table th {
            text-align: left;
            padding: 12px;
            border-bottom: 2px solid #e5e7eb;
            color: #6b7280;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .table td {
            padding: 12px;
            border-bottom: 1px solid #e5e7eb;
            color: #374151;
            vertical-align: top;
        }

        .table td.right {
            text-align: right;
        }

        .button {
            display: inline-block;
            background-color: #4f46e5;
            color: white;
            padding: 12px 24px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
            margin-top: 20px;
            font-size: 14px;
        }

        .footer {
            padding: 30px;
            text-align: center;
            color: #9ca3af;
            font-size: 12px;
            background: #f9fafb;
        }

        .summary-row td {
            font-weight: bold;
            border-top: 2px solid #f3f4f6;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1 style="margin:0; font-size: 24px;">New Quotation Received</h1>
            <p style="margin:10px 0 0 0; opacity: 0.9;">Order #{{ $order->order_number }}</p>
        </div>
        <div class="content">
            <p style="color: #374151; font-size: 16px; line-height: 1.5;">Hello {{ $order->name }},</p>
            <p style="color: #4b5563; line-height: 1.5;">Detailed quotation for your recent order
                #{{ $order->order_number }} is ready for your review. Please review the updated prices and confirm your
                order.</p>

            <table class="table">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th class="right">Price</th>
                        <th class="right">Qty</th>
                        <th class="right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($order->items as $item)
                        <tr>
                            <td width="50%">
                                <div style="font-weight: 500;">{{ $item->product->name ?? 'Product' }}</div>
                                @if(isset($item->options['attributes']))
                                    <div style="font-size: 11px; color: #6b7280; margin-top: 4px;">
                                        @foreach($item->options['attributes'] as $attr)
                                            {{ $attr['attribute'] }}: {{ $attr['value'] }} &nbsp;
                                        @endforeach
                                    </div>
                                @endif
                                @if(isset($item->options['discount_percentage']) && $item->options['discount_percentage'] > 0)
                                    <div style="font-size: 11px; color: #10b981; margin-top: 2px;">
                                        {{ $item->options['discount_percentage'] }}% Discount Applied
                                    </div>
                                @endif
                            </td>
                            <td class="right">₹{{ number_format($item->price, 2) }}</td>
                            <td class="right">{{ $item->quantity }}</td>
                            <td class="right">₹{{ number_format($item->total, 2) }}</td>
                        </tr>
                    @endforeach
                    <tr class="summary-row">
                        <td colspan="3" class="right">Subtotal</td>
                        <td class="right">₹{{ number_format($order->subtotal, 2) }}</td>
                    </tr>
                    <tr>
                        <td colspan="3" class="right">Shipping</td>
                        <td class="right">₹{{ number_format($order->shipping_cost, 2) }}</td>
                    </tr>
                    <tr>
                        <td colspan="3" class="right" style="color: #111827; font-size: 16px;">Total</td>
                        <td class="right" style="color: #111827; font-size: 16px;">
                            ₹{{ number_format($order->total, 2) }}</td>
                    </tr>
                </tbody>
            </table>

            <div style="text-align: center;">
                <a href="{{ route('reseller.orders.index') }}" class="button">Review & Accept Quotation</a>
            </div>
        </div>
        <div class="footer">
            &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
        </div>
    </div>
</body>

</html>