@extends('layouts.shop')

@section('title', 'My Wallet - Delivery Agent')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                {{-- Sidebar --}}
                @include('delivery.partials.sidebar')

                {{-- Main Content --}}
                <div class="md:w-3/4 space-y-6">

                    {{-- Page Header --}}
                    <div class="flex items-center justify-between">
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">My Earnings Wallet</h1>
                            <p class="text-sm text-gray-500 mt-1">Track your delivery rewards and points balance.</p>
                        </div>
                    </div>

                    {{-- Wallet Balance Card --}}
                    <div class="relative overflow-hidden rounded-3xl bg-gradient-to-br from-indigo-900 via-indigo-800 to-indigo-900 shadow-xl border border-indigo-700 text-white">
                        
                        {{-- Decorative Background --}}
                        <div class="absolute top-0 right-0 p-8 opacity-[0.07] pointer-events-none">
                            <svg class="h-64 w-64" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M21 18v1c0 1.1-.9 2-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h14c1.1 0 2 .9 2 2v1h-9c-1.11 0-2 .89-2 2v8a2 2 0 0 0 2 2h9zm-9-2h9c0 .55-.45 1-1 1h-8zm7-11V6h-7c.55 0 1 .45 1 1z" />
                            </svg>
                        </div>

                        <div class="relative z-10 p-8 flex flex-col md:flex-row justify-between items-center gap-8">
                            
                            {{-- Balance Section --}}
                            <div class="flex-1">
                                <p class="text-indigo-200 font-bold uppercase tracking-widest text-xs mb-2">Current Balance</p>
                                <div class="flex items-baseline gap-2">
                                    <h2 class="text-5xl font-black tracking-tight">{{ number_format($user->wallet_balance ?? 0) }}</h2>
                                    <span class="text-2xl font-medium text-indigo-300">Pts</span>
                                </div>

                                @if(isset($settings) && $settings->delivery_wallet_min_redeem)
                                    <div class="mt-6 inline-flex items-center gap-2.5 bg-white/10 backdrop-blur-md px-4 py-2 rounded-full border border-white/10">
                                        <div class="w-2.5 h-2.5 rounded-full {{ ($user->wallet_balance >= $settings->delivery_wallet_min_redeem) ? 'bg-emerald-400 shadow-[0_0_10px_rgba(52,211,153,0.5)]' : 'bg-amber-400' }}"></div>
                                        <p class="text-sm font-medium">
                                            @if($user->wallet_balance >= $settings->delivery_wallet_min_redeem)
                                                Eligible for Redemption
                                            @else
                                                Reach <span class="font-bold text-white">{{ number_format($settings->delivery_wallet_min_redeem) }} pts</span> to redeem
                                            @endif
                                        </p>
                                    </div>
                                @endif
                            </div>

                            {{-- Earning Rate Badge --}}
                            <div class="flex-shrink-0">
                                <div class="bg-white/10 backdrop-blur-md rounded-2xl p-5 border border-white/10 shadow-inner">
                                    <p class="text-xs text-indigo-200 uppercase tracking-wider font-bold mb-1">Earning Rate</p>
                                    <p class="text-lg font-bold text-white flex items-center gap-2">
                                        {{ $settings->delivery_wallet_earn_rate ?? 0 }} Pts
                                        <span class="text-indigo-300 text-sm font-normal">/ 100 {{ config('app.currency', '₹') }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Transaction History --}}
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
                            <h2 class="text-lg font-bold text-gray-900">Transaction History</h2>
                            @if(method_exists($transactions, 'total'))
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold bg-gray-100 text-gray-600">
                                    {{ $transactions->total() }} Transactions
                                </span>
                            @endif
                        </div>
                        
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-50">
                                <thead class="bg-gray-50/50">
                                    <tr>
                                        <th scope="col" class="px-8 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Date</th>
                                        <th scope="col" class="px-8 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Description</th>
                                        <th scope="col" class="px-8 py-4 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Type</th>
                                        <th scope="col" class="px-8 py-4 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">Amount</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-50">
                                    @forelse($transactions as $transaction)
                                        <tr class="hover:bg-gray-50/80 transition-colors group">
                                            <td class="px-8 py-5 whitespace-nowrap text-sm text-gray-500 font-medium">
                                                {{ $transaction->created_at->format('M d, Y') }}
                                                <span class="text-xs text-gray-400 block mt-0.5">{{ $transaction->created_at->format('h:i A') }}</span>
                                            </td>
                                            <td class="px-8 py-5 text-sm text-gray-900">
                                                <div class="font-medium">{{ $transaction->description }}</div>
                                                @if($transaction->reference_id)
                                                    <div class="text-xs text-gray-400 mt-1 flex items-center gap-1">
                                                        <span>Ref ID:</span>
                                                        <code class="bg-gray-100 px-1.5 py-0.5 rounded text-gray-600 font-mono text-[10px] group-hover:bg-white transition-colors">#{{ $transaction->reference_id }}</code>
                                                    </div>
                                                @endif
                                            </td>
                                            <td class="px-8 py-5 whitespace-nowrap">
                                                <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold capitalize {{ $transaction->type == 'credit' ? 'bg-emerald-50 text-emerald-700 border border-emerald-100' : 'bg-rose-50 text-rose-700 border border-rose-100' }}">
                                                    {{ $transaction->type }}
                                                </span>
                                            </td>
                                            <td class="px-8 py-5 whitespace-nowrap text-right text-sm font-bold {{ $transaction->type == 'credit' ? 'text-emerald-600' : 'text-rose-600' }}">
                                                {{ $transaction->type == 'credit' ? '+' : '-' }}{{ number_format($transaction->amount) }}
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="px-8 py-16 text-center">
                                                <div class="flex flex-col items-center justify-center">
                                                    <div class="h-12 w-12 rounded-full bg-gray-50 flex items-center justify-center mb-3">
                                                        <svg class="h-6 w-6 text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                        </svg>
                                                    </div>
                                                    <p class="text-gray-500 text-sm font-medium">No wallet transactions found.</p>
                                                    <p class="text-gray-400 text-xs mt-1">Transactions will appear here once you start earning.</p>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        @if(method_exists($transactions, 'links') && $transactions->hasPages())
                            <div class="px-8 py-4 border-t border-gray-50 bg-gray-50/50">
                                {{ $transactions->links() }}
                            </div>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection