@extends('layouts.shop')

@section('title', 'Settings - Delivery Agent')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('delivery.partials.sidebar')
                <div class="md:w-3/4 space-y-6">
                    <!-- Availability -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50">
                            <h2 class="text-xl font-bold text-gray-900">Availability Status</h2>
                        </div>
                        <div class="p-8">
                            <form action="{{ route('delivery.settings.update') }}" method="POST">
                                @csrf
                                <input type="hidden" name="toggle_availability" value="1">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="font-medium text-gray-900">Current Status</h3>
                                        <p class="text-sm text-gray-500">Toggle to mark yourself as
                                            {{ $agent->is_available ? 'unavailable' : 'available' }} for new orders.
                                        </p>
                                    </div>
                                    <button type="submit"
                                        class="px-6 py-2 rounded-xl font-bold text-white {{ $agent->is_available ? 'bg-red-500 hover:bg-red-600' : 'bg-green-500 hover:bg-green-600' }}">
                                        {{ $agent->is_available ? 'Go Offline' : 'Go Online' }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Change Password -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50">
                            <h2 class="text-xl font-bold text-gray-900">Change Password</h2>
                        </div>
                        <div class="p-8">
                            <form action="{{ route('delivery.settings.update') }}" method="POST" class="space-y-6" x-data="{ 
                                        password: '', 
                                        strength: 0,
                                        rules: {
                                            length: false,
                                            upper: false,
                                            lower: false,
                                            number: false,
                                            special: false
                                        },
                                        checkStrength() {
                                            const p = this.password;
                                            this.rules.length = p.length >= 8;
                                            this.rules.upper = /[A-Z]/.test(p);
                                            this.rules.lower = /[a-z]/.test(p);
                                            this.rules.number = /[0-9]/.test(p);
                                            this.rules.special = /[^A-Za-z0-9]/.test(p);
                                            this.strength = Object.values(this.rules).filter(Boolean).length;
                                        }
                                    }">
                                @csrf
                                <input type="hidden" name="update_password" value="1">

                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-1">Current Password</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                            </svg>
                                        </div>
                                        <input type="password" name="current_password" required
                                            class="w-full rounded-lg border-gray-300 pl-10 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                    </div>
                                </div>

                                <div x-data="{ show: false }">
                                    <label class="block text-sm font-bold text-gray-700 mb-1">New Password</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                            </svg>
                                        </div>
                                        <input :type="show ? 'text' : 'password'" name="password" x-model="password"
                                            @input="checkStrength()" required
                                            class="w-full rounded-lg border-gray-300 pl-10 pr-10 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                        <button type="button" @click="show = !show"
                                            class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                            <svg x-show="!show" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                            <svg x-show="show" x-cloak class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                            </svg>
                                        </button>
                                    </div>

                                    <!-- Strength Bar -->
                                    <div class="h-1.5 w-full bg-gray-200 rounded-full overflow-hidden mt-2">
                                        <div class="h-full transition-all duration-300" :class="{
                                                    'bg-red-500 w-1/5': strength <= 1,
                                                    'bg-orange-500 w-2/5': strength == 2,
                                                    'bg-yellow-500 w-3/5': strength == 3,
                                                    'bg-blue-500 w-4/5': strength == 4,
                                                    'bg-green-500 w-full': strength == 5
                                                }"></div>
                                    </div>

                                    <!-- Rules List -->
                                    <div class="mt-2 flex flex-wrap gap-x-4 gap-y-1 text-xs">
                                        <span :class="rules.length ? 'text-green-600 font-medium' : 'text-gray-500'">
                                            <span x-text="rules.length ? '✓' : '○'"></span> Min 8 chars
                                        </span>
                                        <span :class="rules.upper ? 'text-green-600 font-medium' : 'text-gray-500'">
                                            <span x-text="rules.upper ? '✓' : '○'"></span> Uppercase
                                        </span>
                                        <span :class="rules.lower ? 'text-green-600 font-medium' : 'text-gray-500'">
                                            <span x-text="rules.lower ? '✓' : '○'"></span> Lowercase
                                        </span>
                                        <span :class="rules.number ? 'text-green-600 font-medium' : 'text-gray-500'">
                                            <span x-text="rules.number ? '✓' : '○'"></span> Number
                                        </span>
                                        <span :class="rules.special ? 'text-green-600 font-medium' : 'text-gray-500'">
                                            <span x-text="rules.special ? '✓' : '○'"></span> Special
                                        </span>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-1">Confirm New Password</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <input type="password" name="password_confirmation" required
                                            class="w-full rounded-lg border-gray-300 pl-10 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                    </div>
                                </div>
                                <div class="pt-2">
                                    <button type="submit"
                                        class="bg-indigo-600 text-white px-6 py-2.5 rounded-xl font-bold hover:bg-indigo-700 transition-colors shadow-sm">Update
                                        Password</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Deactivate Account -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50">
                            <h2 class="text-xl font-bold text-red-600">Danger Zone</h2>
                        </div>
                        <div class="p-8">
                            <p class="text-sm text-gray-600 mb-4">Once you deactivate your account, you will be logged out
                                and unable to access the delivery panel until an admin reactivates it.</p>
                            <form action="{{ route('delivery.settings.update') }}" method="POST"
                                onsubmit="return confirm('Are you sure you want to deactivate your account?');">
                                @csrf
                                <input type="hidden" name="deactivate_account" value="1">
                                <button type="submit"
                                    class="bg-red-50 text-red-600 border border-red-200 px-6 py-2 rounded-xl font-bold hover:bg-red-100">Deactivate
                                    Account</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection