@extends('layouts.shop')

@section('title', 'My Profile - Delivery Agent')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('delivery.partials.sidebar')
                <div class="md:w-3/4">
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50">
                            <h2 class="text-xl font-bold text-gray-900">My Profile</h2>
                        </div>
                        <div class="p-8">
                            <form id="profile-update-form" action="{{ route('delivery.profile.update') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="md:col-span-2 flex items-center space-x-6">
                                        <div class="shrink-0">
                                            @if($user->profile_photo_path)
                                                <img class="h-24 w-24 object-cover rounded-full border border-gray-200" src="{{ Storage::url($user->profile_photo_path) }}" alt="{{ $user->name }}">
                                            @else
                                                <div class="h-24 w-24 rounded-full bg-gray-200 flex items-center justify-center text-gray-500">
                                                    <svg class="h-12 w-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                                </div>
                                            @endif
                                        </div>
                                        <label class="block">
                                            <span class="sr-only">Choose profile photo</span>
                                            <input type="file" name="profile_photo" class="block w-full text-sm text-slate-500
                                              file:mr-4 file:py-2 file:px-4
                                              file:rounded-full file:border-0
                                              file:text-sm file:font-semibold
                                              file:bg-indigo-50 file:text-indigo-700
                                              hover:file:bg-indigo-100
                                            "/>
                                        </label>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-bold text-gray-700 mb-1">Full Name</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="name" value="{{ old('name', $user->name) }}" required
                                                class="w-full rounded-lg border-gray-300 pl-10 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-bold text-gray-700 mb-1">Email Address</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="email" value="{{ $user->email }}" disabled
                                                class="w-full rounded-lg border-gray-300 pl-10 bg-gray-100 text-gray-500 cursor-not-allowed sm:text-sm border p-2.5">
                                        </div>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-bold text-gray-700 mb-1">Phone Number</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="phone"
                                                value="{{ old('phone', $agent->phone ?? $user->phone) }}" required
                                                class="w-full rounded-lg border-gray-300 pl-10 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                        </div>
                                    </div>

                                    <div class="md:col-span-2 mt-4">
                                        <h3 class="text-lg font-bold text-gray-900 mb-4 pb-2 border-b border-gray-50">Bank Details</h3>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <label class="block text-sm font-bold text-gray-700 mb-1">Bank Name</label>
                                                <input type="text" name="bank_name" value="{{ old('bank_name', $agent->bank_name) }}"
                                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-bold text-gray-700 mb-1">Account Number</label>
                                                <input type="text" name="account_number" value="{{ old('account_number', $agent->account_number) }}"
                                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                            </div>
                                            <div class="md:col-span-2">
                                                <label class="block text-sm font-bold text-gray-700 mb-1">IFSC Code</label>
                                                <input type="text" name="ifsc_code" value="{{ old('ifsc_code', $agent->ifsc_code) }}"
                                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white transition-colors">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <!-- Read Only Information -->
                            <div class="space-y-8">
                                <!-- Contact Information -->
                                <div>
                                    <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                                        Contact Information
                                    </h3>
                                    <div class="bg-gray-50 rounded-2xl p-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <p class="text-sm text-gray-500">Alternate Phone</p>
                                            <p class="font-medium text-gray-900">{{ $agent->alternate_phone ?? 'N/A' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">Date of Birth</p>
                                            <p class="font-medium text-gray-900">{{ $agent->dob ? $agent->dob->format('M d, Y') : 'N/A' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">Gender</p>
                                            <p class="font-medium text-gray-900">{{ $agent->gender ?? 'N/A' }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm text-gray-500">Full Address</p>
                                            <p class="font-medium text-gray-900">{{ $agent->address ?? 'N/A' }}</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Vehicles Information -->
                                <div>
                                    <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                                        Registered Vehicles
                                    </h3>
                                    @if($agent->vehicles->count() > 0)
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            @foreach($agent->vehicles as $vehicle)
                                                <div class="bg-white border border-gray-200 rounded-xl p-4 flex items-start space-x-4 shadow-sm">
                                                    <div class="p-3 bg-indigo-50 rounded-lg">
                                                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 012-2v0m2 0a2 2 0 012 2l0 0m-2 0a2 2 0 012-2v0m2 9a2 2 0 012 2v0m2-2a2 2 0 012-2v0"></path></svg>
                                                    </div>
                                                    <div>
                                                        <p class="font-bold text-gray-900">{{ $vehicle->vehicle_number }}</p>
                                                        <p class="text-sm text-gray-500">{{ $vehicle->type }}</p>
                                                        @if($vehicle->model)<p class="text-xs text-gray-400">{{ $vehicle->model }}</p>@endif
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @else
                                        <p class="text-gray-500 text-sm">No vehicles registered.</p>
                                    @endif
                                </div>

                                <!-- KYC Documents -->
                                <div>
                                    <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                        <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                                        KYC Documents
                                    </h3>
                                    @if($agent->documents->count() > 0)
                                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                                            @foreach($agent->documents as $doc)
                                                <div class="bg-white border border-gray-200 rounded-2xl overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                                                    <div class="aspect-w-16 aspect-h-9 bg-gray-100">
                                                        @if($doc->image_path)
                                                            <a href="{{ Storage::url($doc->image_path) }}" target="_blank">
                                                                <img src="{{ Storage::url($doc->image_path) }}" alt="{{ $doc->type }}" class="object-cover w-full h-48">
                                                            </a>
                                                        @else
                                                            <div class="flex items-center justify-center h-48 text-gray-400">
                                                                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="p-4">
                                                        <p class="font-bold text-gray-900">{{ ucfirst(str_replace('_', ' ', $doc->type)) }}</p>
                                                        <p class="text-sm text-gray-500 font-mono mt-1">{{ $doc->number ?? 'No ID Number' }}</p>
                                                        <a href="{{ Storage::url($doc->image_path) }}" target="_blank" class="text-xs text-indigo-600 font-semibold mt-2 inline-block">View Full Image</a>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @else
                                        <p class="text-gray-500 text-sm">No documents found.</p>
                                    @endif
                                </div>

                                <div class="pt-10 flex justify-center">
                                    <button type="submit" form="profile-update-form" class="w-full md:w-1/2 bg-indigo-600 text-white px-8 py-4 rounded-2xl font-bold shadow-lg shadow-indigo-100 hover:bg-indigo-700 hover:shadow-indigo-200 transition-all transform hover:-translate-y-1">
                                        Update Profile
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection