@extends('layouts.shop')

@section('title', 'Order #' . $order->order_number . ' - Delivery')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('delivery.partials.sidebar')
                <div class="md:w-3/4">
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden mb-6">
                        <div class="px-8 py-6 border-b border-gray-50 flex justify-between items-center">
                            <h2 class="text-xl font-bold text-gray-900">Order #{{ $order->order_number }}</h2>
                            <span
                                class="px-3 py-1 bg-gray-100 rounded-full text-sm font-bold text-gray-600">{{ ucfirst($order->status) }}</span>
                        </div>
                        <div class="p-8">
                            <h3 class="font-bold text-lg mb-4">Customer Details</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                                <div>
                                    <p class="text-sm text-gray-500">Name</p>
                                    <p class="font-medium">{{ $order->shippingAddress->name ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Phone</p>
                                    <p class="font-medium"><a href="tel:{{ $order->shippingAddress->phone ?? '' }}"
                                            class="text-indigo-600">{{ $order->shippingAddress->phone ?? 'N/A' }}</a></p>
                                </div>
                                <div class="col-span-2">
                                    <p class="text-sm text-gray-500">Address</p>
                                    <p class="font-medium">
                                        {{ $order->shippingAddress->address_line1 ?? '' }}<br>
                                        {{ $order->shippingAddress->address_line2 ?? '' }}<br>
                                        {{ $order->shippingAddress->city ?? '' }},
                                        {{ $order->shippingAddress->state ?? '' }} -
                                        {{ $order->shippingAddress->postal_code ?? '' }}
                                    </p>
                                    <a href="https://maps.google.com/?q={{ urlencode(($order->shippingAddress->address_line1 ?? '') . ' ' . ($order->shippingAddress->city ?? '')) }}"
                                        target="_blank" class="text-indigo-600 text-sm font-bold mt-2 inline-block">Open in
                                        Maps</a>
                                </div>
                            </div>

                            @if($order->pickupStore)
                                <div class="bg-indigo-50 rounded-2xl p-6 border border-indigo-100 mb-8">
                                    <h3 class="font-bold text-lg mb-4 text-indigo-900 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                        </svg>
                                        Pickup Location
                                    </h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <p class="text-sm text-indigo-600 font-medium">Store Name</p>
                                            <p class="font-bold text-gray-900">{{ $order->pickupStore->name }}</p>
                                        </div>
                                        <div>
                                            <p class="text-sm text-indigo-600 font-medium">Contact</p>
                                            <p class="font-bold text-gray-900">{{ $order->pickupStore->phone ?? 'N/A' }}</p>
                                        </div>
                                        <div class="col-span-2">
                                            <p class="text-sm text-indigo-600 font-medium">Store Address</p>
                                            <p class="font-medium text-gray-800">
                                                {{ $order->pickupStore->address_line1 }}<br>
                                                {{ $order->pickupStore->city }}, {{ $order->pickupStore->state }} -
                                                {{ $order->pickupStore->postal_code }}
                                            </p>
                                            <a href="https://maps.google.com/?q={{ urlencode($order->pickupStore->address_line1 . ' ' . $order->pickupStore->city) }}"
                                                target="_blank" class="text-indigo-600 text-sm font-bold mt-2 inline-block">Get
                                                Directions</a>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <h3 class="font-bold text-lg mb-4">Order Items</h3>
                            <ul class="divide-y divide-gray-100 mb-8">
                                @foreach($order->items as $item)
                                    <li class="py-4 flex justify-between">
                                        <div>
                                            <p class="font-medium">{{ $item->product->name }}</p>
                                            <p class="text-sm text-gray-500">Qty: {{ $item->quantity }} @if($item->variation) |
                                            {{ $item->variation->name ?? 'Var' }} @endif
                                            </p>
                                        </div>
                                        <p class="font-bold">₹{{ number_format($item->price * $item->quantity, 2) }}</p>
                                    </li>
                                @endforeach
                            </ul>
                            <div class="border-t border-gray-100 pt-4 flex justify-between font-bold text-lg">
                                <span>Total to Collect (if COD)</span>
                                <span
                                    class="{{ $order->payment_method == 'cod' && ($order->payment_status == 'paid' || $order->status == 'completed') ? 'text-green-600' : '' }}">
                                    @if($order->payment_method == 'cod')
                                        @if($order->payment_status == 'paid' || $order->status == 'completed')
                                            Paid
                                        @else
                                            ₹{{ number_format($order->total, 2) }}
                                        @endif
                                    @else
                                        Paid Online
                                    @endif
                                </span>
                            </div>
                        </div>

                        @if($order->status == 'completed' && ($order->agentRating || $order->productReviews->isNotEmpty()))
                            <div class="mt-8 pt-8 border-t border-gray-100">
                                <h3 class="font-bold text-lg mb-6">Customer Feedback</h3>

                                @if($order->agentRating)
                                    <div class="bg-amber-50 rounded-2xl p-6 border border-amber-100 mb-6">
                                        <div class="flex items-center justify-between mb-2">
                                            <p class="text-sm text-amber-800 font-bold uppercase tracking-wider">Delivery Rating</p>
                                            <div class="flex items-center gap-1">
                                                @for($i = 1; $i <= 5; $i++)
                                                    <svg class="w-5 h-5 {{ $i <= $order->agentRating->rating ? 'fill-amber-500 text-amber-500' : 'text-gray-200 fill-gray-200' }}"
                                                        viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                    </svg>
                                                @endfor
                                            </div>
                                        </div>
                                        @if($order->agentRating->comment)
                                            <p class="text-gray-700 italic font-medium">"{{ $order->agentRating->comment }}"</p>
                                        @endif
                                    </div>
                                @endif

                                @if($order->productReviews->isNotEmpty())
                                    <div class="space-y-4">
                                        <p class="text-xs font-black text-gray-400 uppercase tracking-widest mb-2">Product Reviews
                                        </p>
                                        @foreach($order->productReviews as $review)
                                            <div class="flex items-start gap-4 p-4 bg-gray-50 rounded-xl border border-gray-100">
                                                <div class="flex-1">
                                                    <div class="flex justify-between items-center mb-1">
                                                        <p class="font-bold text-sm text-gray-900">{{ $review->product->name }}</p>
                                                        <div class="flex items-center gap-0.5">
                                                            @for($i = 1; $i <= 5; $i++)
                                                                <svg class="w-3 h-3 {{ $i <= $review->rating ? 'fill-amber-500 text-amber-500' : 'text-gray-200 fill-gray-200' }}"
                                                                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                                </svg>
                                                            @endfor
                                                        </div>
                                                    </div>
                                                    @if($review->comment)
                                                        <p class="text-xs text-gray-600 italic">"{{ $review->comment }}"</p>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>

                    <!-- Actions -->
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 p-8"
                        x-data="{ showCancelForm: false }">
                        <h3 class="font-bold text-lg mb-4">Update Status</h3>

                        <!-- Normal Actions -->
                        <div x-show="!showCancelForm">
                            <form action="{{ route('delivery.orders.update-status', $order->id) }}" method="POST"
                                class="space-y-4">
                                @csrf
                                <div class="flex flex-col md:flex-row gap-4">
                                    @if($order->status == 'processing' || $order->status == 'pending')
                                        <button type="submit" name="status" value="shipped"
                                            class="flex-1 bg-blue-600 text-white py-3 rounded-xl font-bold hover:bg-blue-700 transition-colors shadow-sm">
                                            Pick Up / Start Delivery
                                        </button>
                                    @endif
                                    @if($order->status == 'shipped')
                                        <button type="submit" name="status" value="completed"
                                            class="flex-1 bg-green-600 text-white py-3 rounded-xl font-bold hover:bg-green-700 transition-colors shadow-sm">
                                            Mark Delivered
                                        </button>
                                        <button type="button" @click="showCancelForm = true"
                                            class="flex-1 bg-red-100 text-red-700 py-3 rounded-xl font-bold hover:bg-red-200 transition-colors shadow-sm border border-red-200">
                                            Mark Failed/Cancelled
                                        </button>
                                    @endif
                                </div>
                            </form>
                        </div>

                        <!-- Cancellation Form -->
                        <div x-show="showCancelForm" x-cloak
                            class="mt-4 bg-red-50 p-6 rounded-2xl border border-red-100 animate-fade-in-down">
                            <h4 class="font-bold text-red-800 mb-2">Cancellation Details</h4>
                            <form action="{{ route('delivery.orders.update-status', $order->id) }}" method="POST"
                                class="space-y-4">
                                @csrf
                                <input type="hidden" name="status" value="cancelled">
                                <div>
                                    <label class="block text-sm font-medium text-red-700 mb-1">Reason for
                                        Cancellation</label>
                                    <textarea name="reason" rows="3" required
                                        class="w-full rounded-lg border-red-300 focus:border-red-500 focus:ring-red-500"
                                        placeholder="e.g., Customer refused delivery, Address not found..."></textarea>
                                </div>
                                <div class="flex gap-3">
                                    <button type="submit"
                                        class="flex-1 bg-red-600 text-white py-2 rounded-lg font-bold hover:bg-red-700 shadow-sm">
                                        Confirm Cancellation
                                    </button>
                                    <button type="button" @click="showCancelForm = false"
                                        class="px-4 py-2 bg-white text-gray-700 border border-gray-300 rounded-lg font-medium hover:bg-gray-50">
                                        Back
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
<script>
    if ("geolocation" in navigator) {
        function updateAgentLocation() {
            navigator.geolocation.getCurrentPosition(function(position) {
                fetch('{{ route('delivery.update-location') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        latitude: position.coords.latitude,
                        longitude: position.coords.longitude
                    })
                })
                .then(res => res.json())
                .then(data => {
                    console.log('Location updated');
                })
                .catch(err => console.error('Location update failed', err));
            }, function(error) {
                console.error("Geolocation error: " + error.message);
            }, {
                enableHighAccuracy: true,
                timeout: 5000,
                maximumAge: 0
            });
        }
        
        // Update immediately and then every 30 seconds
        updateAgentLocation();
        setInterval(updateAgentLocation, 30000);
    } else {
        console.warn("Geolocation is not supported by this browser.");
    }
</script>
@endpush
@endsection