@extends('layouts.shop')

@section('title', 'My Orders - Delivery Agent')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('delivery.partials.sidebar')
                <div class="md:w-3/4">
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50">
                            <h2 class="text-xl font-bold text-gray-900">My Orders</h2>
                            <div class="mt-4 flex space-x-2 overflow-x-auto pb-2">
                                <a href="{{ route('delivery.orders', ['status' => 'assigned']) }}"
                                    class="px-4 py-2 rounded-lg text-sm font-medium {{ $status == 'assigned' ? 'bg-indigo-100 text-indigo-700' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">New
                                    / Assigned ({{ $assignedCount }})</a>
                                <a href="{{ route('delivery.orders', ['status' => 'transit']) }}"
                                    class="px-4 py-2 rounded-lg text-sm font-medium {{ $status == 'transit' ? 'bg-blue-100 text-blue-700' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">In
                                    Transit ({{ $transitCount }})</a>
                                <a href="{{ route('delivery.orders', ['status' => 'completed']) }}"
                                    class="px-4 py-2 rounded-lg text-sm font-medium {{ $status == 'completed' ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Completed
                                    ({{ $completedCount }})</a>
                                <a href="{{ route('delivery.orders', ['status' => 'cancelled']) }}"
                                    class="px-4 py-2 rounded-lg text-sm font-medium {{ $status == 'cancelled' ? 'bg-red-100 text-red-700' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">Cancelled
                                    ({{ $cancelledCount }})</a>
                            </div>
                        </div>

                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-100">
                                <thead class="bg-gray-50/50">
                                    <tr>
                                        <th
                                            class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                            Order</th>
                                        <th
                                            class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                            Customer</th>
                                        <th
                                            class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                            Address</th>
                                        <th
                                            class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                            Total</th>
                                        <th
                                            class="px-6 py-4 text-right text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-100">
                                    @foreach($orders as $order)
                                        <tr class="hover:bg-gray-50/50 transition-colors duration-200">
                                            <td class="px-6 py-4 whitespace-nowrap"><span
                                                    class="text-sm font-bold text-gray-900">#{{ $order->order_number }}</span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900 font-medium">
                                                    {{ $order->shippingAddress->name ?? 'N/A' }}
                                                </div>
                                                <div class="text-xs text-gray-500">{{ $order->shippingAddress->phone ?? 'N/A' }}
                                                </div>
                                            </td>
                                            <td class="px-6 py-4">
                                                <span class="text-sm text-gray-600 truncate block max-w-xs">
                                                    {{ $order->shippingAddress->address_line1 ?? '' }},
                                                    {{ $order->shippingAddress->city ?? '' }}
                                                </span>
                                                @if($order->pickupStore)
                                                    <span
                                                        class="text-[10px] font-bold text-indigo-600 bg-indigo-50 px-2 py-0.5 rounded-full mt-1 inline-block">
                                                        Pickup: {{ $order->pickupStore->name }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap"><span
                                                    class="text-sm font-bold text-gray-900">₹{{ number_format($order->total, 2) }}</span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                <div class="flex items-center justify-end space-x-3">
                                                    @if($order->status == 'shipped')
                                                        <form action="{{ route('delivery.orders.update-status', $order->id) }}"
                                                            method="POST"
                                                            onsubmit="return confirm('Confirm delivery completion?');">
                                                            @csrf
                                                            <button type="submit" name="status" value="completed"
                                                                class="text-green-600 hover:text-green-900 font-bold text-xs bg-green-50 px-2 py-1 rounded border border-green-200">
                                                                Complete
                                                            </button>
                                                        </form>
                                                    @endif
                                                    <a href="{{ route('delivery.orders.show', $order->id) }}"
                                                        class="text-indigo-600 hover:text-indigo-900 font-bold">View</a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="px-8 py-4 border-t border-gray-100">
                            {{ $orders->appends(['status' => $status])->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection