@extends('layouts.shop')

@section('title', 'Notifications - Delivery Agent')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('delivery.partials.sidebar')
                <div class="md:w-3/4">
                    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50 flex justify-between items-center">
                            <h2 class="text-xl font-bold text-gray-900">Notifications</h2>
                        </div>
                        <div class="p-8">
                            @if($notifications->count() > 0)
                                <div class="space-y-4">
                                    @foreach($notifications as $notification)
                                        <div
                                            class="p-4 rounded-xl border {{ $notification->read_at ? 'bg-white border-gray-200' : 'bg-blue-50 border-blue-200' }}">
                                            <div class="flex justify-between items-start">
                                                <h3 class="font-bold text-gray-900">
                                                    {{ $notification->data['title'] ?? 'Notification' }}</h3>
                                                <span
                                                    class="text-xs text-gray-500">{{ $notification->created_at->diffForHumans() }}</span>
                                            </div>
                                            <p class="text-gray-700 mt-1">{{ $notification->data['message'] ?? '' }}</p>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="mt-4">
                                    {{ $notifications->links() }}
                                </div>
                            @else
                                <div class="text-center py-12">
                                    <svg class="mx-auto h-12 w-12 text-gray-300" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                                    </svg>
                                    <h3 class="mt-2 text-sm font-medium text-gray-900">No notifications</h3>
                                    <p class="mt-1 text-sm text-gray-500">You're all caught up!</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection