@extends('layouts.shop')

@section('title', 'Delivery Dashboard - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                <!-- Sidebar -->
                @include('delivery.partials.sidebar')

                <!-- Main Content -->
                <div class="md:w-3/4">
                    <!-- Welcome Banner -->
                    <div
                        class="relative overflow-hidden rounded-3xl bg-gradient-to-r from-violet-600 to-indigo-600 p-10 mb-10 shadow-xl">
                        <h1 class="text-3xl font-extrabold text-white mb-2 tracking-tight">
                            Welcome, {{ Auth::user()->name }}!
                        </h1>
                        <div class="absolute top-6 right-6">
                            <a href="{{ route('delivery.notifications') }}"
                                class="relative inline-block p-2 rounded-full bg-white/20 hover:bg-white/30 transition-colors">
                                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                                </svg>
                                @if($unreadNotifications > 0)
                                    <span
                                        class="absolute top-2 right-2 block h-2.5 w-2.5 rounded-full ring-2 ring-white bg-red-500 animate-ping"></span>
                                    <span
                                        class="absolute top-2 right-2 block h-2.5 w-2.5 rounded-full ring-2 ring-white bg-red-500"></span>
                                @endif
                            </a>
                        </div>
                        <p class="text-indigo-100 text-lg max-w-xl">
                            Manage your deliveries, view your assigned orders, and update your status.
                        </p>
                        <div class="mt-4">
                            <span
                                class="px-4 py-2 rounded-full text-sm font-bold {{ $agent->is_available ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                Current Status: {{ $agent->is_available ? 'Available' : 'Unavailable' }}
                            </span>
                        </div>
                    </div>
                    <!-- Decorative Circles -->
                    <div class="absolute top-0 right-0 -mr-20 -mt-20 w-96 h-96 rounded-full bg-white/10 blur-3xl"></div>
                    <div class="absolute bottom-0 right-10 w-64 h-64 rounded-full bg-white/5 blur-2xl"></div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-6 mb-10">
                        <!-- Stat Cards -->
                        <div class="bg-white p-6 rounded-2xl shadow-lg border border-gray-100">
                            <p class="text-xs font-bold text-gray-500 uppercase tracking-wider">Assigned</p>
                            <p class="text-3xl font-extrabold text-indigo-600 mt-2">{{ $newOrders }}</p>
                        </div>
                        <div class="bg-white p-6 rounded-2xl shadow-lg border border-gray-100">
                            <p class="text-xs font-bold text-gray-500 uppercase tracking-wider">In Transit</p>
                            <p class="text-3xl font-extrabold text-blue-600 mt-2">{{ $inTransit }}</p>
                        </div>
                        <div class="bg-white p-6 rounded-2xl shadow-lg border border-gray-100">
                            <p class="text-xs font-bold text-gray-500 uppercase tracking-wider">Completed</p>
                            <p class="text-3xl font-extrabold text-green-600 mt-2">{{ $completed }}</p>
                        </div>
                        <div class="bg-white p-6 rounded-2xl shadow-lg border border-gray-100">
                            <p class="text-xs font-bold text-gray-500 uppercase tracking-wider">Cancelled</p>
                            <p class="text-3xl font-extrabold text-red-600 mt-2">{{ $cancelled }}</p>
                        </div>
                        <div class="bg-white p-6 rounded-2xl shadow-lg border border-gray-100">
                            <p class="text-xs font-bold text-gray-500 uppercase tracking-wider">Avg Rating</p>
                            <div class="flex items-center mt-2">
                                <p class="text-3xl font-extrabold text-amber-500 mr-2">
                                    {{ number_format($agent->average_rating, 1) }}
                                </p>
                                <svg class="w-6 h-6 text-amber-400 fill-current" viewBox="0 0 20 20">
                                    <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Financial Stats -->
                    <div
                        class="bg-white p-8 rounded-3xl shadow-lg border border-gray-100 flex items-center justify-between mb-10">
                        <div>
                            <p class="text-sm font-bold text-gray-500 uppercase tracking-wider mb-1">Total Cash Collected
                                (COD)</p>
                            <h3 class="text-4xl font-extrabold text-gray-900">₹{{ number_format($cashCollected ?? 0, 2) }}
                            </h3>
                            <p class="text-sm text-gray-400 mt-2">From {{ $codOrderCount ?? 0 }} completed COD orders</p>
                        </div>
                        <div class="bg-green-100 p-4 rounded-full">
                            <svg class="h-10 w-10 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599
                                1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            if ("geolocation" in navigator) {
                function updateAgentLocation() {
                    navigator.geolocation.getCurrentPosition(function (position) {
                        fetch('{{ route('delivery.update-location') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({
                                latitude: position.coords.latitude,
                                longitude: position.coords.longitude
                            })
                        })
                            .then(res => res.json())
                            .then(data => {
                                console.log('Location updated');
                            })
                            .catch(err => console.error('Location update failed', err));
                    }, function (error) {
                        console.error("Geolocation error: " + error.message);
                    }, {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0
                    });
                }

                // Update immediately and then every 30 seconds
                updateAgentLocation();
                setInterval(updateAgentLocation, 30000);
            } else {
                console.warn("Geolocation is not supported by this browser.");
            }
        </script>
    @endpush
@endsection