@if(isset($customOffers) && $customOffers->count() > 0)
    @foreach($customOffers as $offer)
        {{-- Render the Offer --}}
        <div id="custom-offer-{{ $offer->id }}" class="custom-offer-container mt-20 mb-10 {{ $offer->bg_color && $offer->bg_color != '#ffffff' ? 'py-10' : '' }} {{ $offer->target_element ? 'hidden' : '' }}" 
             style="background-color: {{ $offer->bg_color ?? 'transparent' }};">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="tracking-tight font-serif mb-4"
                        style="color: {{ $offer->heading_color ?? '#111827' }}; 
                               font-size: {{ $offer->heading_font_size ?? '2.25rem' }}; 
                               font-weight: {{ $offer->heading_font_weight ?? '700' }};">
                        {{ $offer->name }}
                    </h2>
                    <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                </div>
                @if($offer->layout)
                    <div class="grid gap-6 {{ 
                        $offer->layout->columns == 1 ? 'grid-cols-1' : 
                        ($offer->layout->columns == 2 ? 'grid-cols-1 md:grid-cols-2' : 'grid-cols-1 md:grid-cols-3') 
                    }}">
                        @foreach($offer->items as $item)
                            <a href="{{ $item->redirect_url ?? '#' }}" class="block group relative overflow-hidden transition-all duration-300 hover:shadow-lg"
                               style="border-radius: {{ $offer->border_radius ?? '0' }}; 
                                      box-shadow: {{ $offer->box_shadow ?? 'none' }};">
                                <div class="aspect-auto w-full bg-gray-100">
                                    <img src="{{ Storage::url($item->banner_image) }}" 
                                         alt="{{ $item->alt_tag ?? 'Offer Banner' }}" 
                                         class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-700 ease-in-out">
                                </div>
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        {{-- Render the Script to Move it --}}
        <x-custom-offer-script :offer="$offer" />
    @endforeach
@endif
