@props(['offer'])

@if($offer->target_element)
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const offerElement = document.getElementById('custom-offer-{{ $offer->id }}');
            const targetElement = document.querySelector('{{ $offer->target_element }}');
            
            if (offerElement && targetElement) {
                // Determine placement
                const position = '{{ $offer->placement_position ?? "after" }}';
                console.log('Moving Offer {{ $offer->id }} to', position, 'of', '{{ $offer->target_element }}');
                
                if (position === 'before') {
                    targetElement.parentNode.insertBefore(offerElement, targetElement);
                } else if (position === 'after') {
                    // Check if next sibling exists, otherwise append to parent
                    if (targetElement.nextSibling) {
                        targetElement.parentNode.insertBefore(offerElement, targetElement.nextSibling);
                    } else {
                        targetElement.parentNode.appendChild(offerElement);
                    }
                } else if (position === 'inside_start') {
                    targetElement.insertBefore(offerElement, targetElement.firstChild);
                } else if (position === 'inside_end') {
                    targetElement.appendChild(offerElement);
                }
                
                // Show the offer after moving
                offerElement.classList.remove('hidden');
            } else {
                console.warn('Custom Offer Script: Target element "{{ $offer->target_element }}" not found.');
                // Fallback: Show it in original position if target not found
                if (offerElement) {
                    offerElement.classList.remove('hidden');
                }
                // Optional: Show it somewhere default or keep hidden? 
                // Currently keeping hidden as fallback might break layout.
            }
        });
    </script>
@endif
