<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallet Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Wallet Settings</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow">
                <div class="p-6">
                    <form action="{{ route('admin.settings.wallet.update') }}" method="POST">
                        @csrf

                        <h3 class="text-lg font-medium leading-6 text-gray-900 mb-6">Wallet Configuration</h3>
                        <p class="mb-4 text-sm text-gray-500">Configure how users earn and redeem points.</p>

                        <div class="space-y-6">
                            <!-- Toggle Wallet -->
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="wallet_enabled" name="wallet_enabled" type="checkbox"
                                        {{ $settings->wallet_enabled ? 'checked' : '' }}
                                        class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="wallet_enabled" class="font-medium text-gray-700">Enable Wallet System</label>
                                    <p class="text-gray-500">If disabled, users cannot earn or redeem points.</p>
                                </div>
                            </div>
                            
                            <hr class="border-gray-200">

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                
                                <!-- Exchange Rate -->
                                <div>
                                    <label for="wallet_exchange_rate" class="block text-sm font-medium text-gray-700">
                                        Exchange Rate (Points = 1 {{ config('app.currency', '₹') }})
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="number" name="wallet_exchange_rate" id="wallet_exchange_rate"
                                            value="{{ old('wallet_exchange_rate', $settings->wallet_exchange_rate ?? 100) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="100">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">How many points make 1 unit of currency. E.g., 100 Points = ₹1.</p>
                                </div>

                                <!-- Min Points to Redeem -->
                                <div>
                                    <label for="wallet_min_points_redeem" class="block text-sm font-medium text-gray-700">
                                        Minimum Points to Redeem
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="number" name="wallet_min_points_redeem" id="wallet_min_points_redeem"
                                            value="{{ old('wallet_min_points_redeem', $settings->wallet_min_points_redeem ?? 1000) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="1000">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">Users must have at least this many points to start redeeming.</p>
                                </div>



                                <!-- Earn Rate -->
                                <div>
                                    <label for="wallet_earn_rate" class="block text-sm font-medium text-gray-700">
                                        Earning Rate (Points per 100 {{ config('app.currency', '₹') }} spent)
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="number" name="wallet_earn_rate" id="wallet_earn_rate"
                                            value="{{ old('wallet_earn_rate', $settings->wallet_earn_rate ?? 10) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="10">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">How many points a user earns for every 100 units spent. E.g., 10 means 10 points for every ₹100 purchase.</p>
                                </div>
                            </div>
                            <hr class="border-gray-200">

                            <h3 class="text-lg font-medium leading-6 text-gray-900">Gift Card Configuration</h3>
                            <div class="space-y-6">
                                <div class="flex items-start">
                                    <div class="flex items-center h-5">
                                        <input id="gift_card_enabled" name="gift_card_enabled" type="checkbox"
                                            {{ $settings->gift_card_enabled ? 'checked' : '' }}
                                            class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                    </div>
                                    <div class="ml-3 text-sm">
                                        <label for="gift_card_enabled" class="font-medium text-gray-700">Enable Gift Card System</label>
                                        <p class="text-gray-500">Allow users to create and redeem gift cards.</p>
                                    </div>
                                </div>

                                <div>
                                    <label for="gift_card_expiry_days" class="block text-sm font-medium text-gray-700">
                                        Gift Card Validity (Days)
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm max-w-xs">
                                        <input type="number" name="gift_card_expiry_days" id="gift_card_expiry_days"
                                            value="{{ old('gift_card_expiry_days', $settings->gift_card_expiry_days ?? 365) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="365">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">Number of days a gift card remains valid after creation.</p>
                                </div>
                            </div>
                            
                            <hr class="border-gray-200">

                            <h3 class="text-lg font-medium leading-6 text-gray-900">Delivery Agent Wallet Configuration</h3>
                            <div class="space-y-6">
                                <div class="flex items-start">
                                    <div class="flex items-center h-5">
                                        <input id="delivery_wallet_enabled" name="delivery_wallet_enabled" type="checkbox"
                                            {{ $settings->delivery_wallet_enabled ? 'checked' : '' }}
                                            class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                    </div>
                                    <div class="ml-3 text-sm">
                                        <label for="delivery_wallet_enabled" class="font-medium text-gray-700">Enable Delivery Wallet System</label>
                                        <p class="text-gray-500">Allow delivery agents to earn points on deliveries.</p>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="delivery_wallet_earn_rate" class="block text-sm font-medium text-gray-700">
                                            Earning Rate (Points per 100 {{ config('app.currency', '₹') }} delivery amount)
                                        </label>
                                        <div class="mt-1 relative rounded-md shadow-sm">
                                            <input type="number" name="delivery_wallet_earn_rate" id="delivery_wallet_earn_rate"
                                                value="{{ old('delivery_wallet_earn_rate', $settings->delivery_wallet_earn_rate ?? 0) }}"
                                                class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                                placeholder="10">
                                        </div>
                                        <p class="mt-2 text-sm text-gray-500">Points earned by agent per 100 currency units of the order total.</p>
                                    </div>

                                    <div>
                                        <label for="delivery_wallet_min_redeem" class="block text-sm font-medium text-gray-700">
                                            Minimum Points to Redeem
                                        </label>
                                        <div class="mt-1 relative rounded-md shadow-sm">
                                            <input type="number" name="delivery_wallet_min_redeem" id="delivery_wallet_min_redeem"
                                                value="{{ old('delivery_wallet_min_redeem', $settings->delivery_wallet_min_redeem ?? 1000) }}"
                                                class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                                placeholder="1000">
                                        </div>
                                        <p class="mt-2 text-sm text-gray-500">Minimum points required for payout/redemption.</p>
                                    </div>
                                </div>
                            </div>

                        <div class="flex justify-end border-t border-gray-200 mt-8 pt-5">
                            <button type="submit"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Save Changes
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>
