<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Tax Rate - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <h2 class="text-xl font-bold text-gray-800 tracking-tight">Edit Tax Rate</h2>
            </div>
            <a href="{{ route('admin.tax-rates.index') }}"
                class="text-sm font-medium text-gray-500 hover:text-gray-900 transition-colors">
                &larr; Back to List
            </a>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-2xl mx-auto">
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-100">
                    <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                        <h3 class="text-sm font-semibold text-gray-700 uppercase tracking-wider">Update Tax Rate Details
                        </h3>
                    </div>

                    <form action="{{ route('admin.tax-rates.update', $taxRate->id) }}" method="POST"
                        class="p-6 space-y-6">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Tax Name <span
                                        class="text-red-500">*</span></label>
                                <input type="text" name="name" id="name"
                                    class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 shadow-sm transition-colors"
                                    placeholder="e.g. GST 18%" required value="{{ old('name', $taxRate->name) }}">
                                <p class="mt-1 text-xs text-gray-500">A unique name to identify this tax rate.</p>
                                @error('name') <span
                                class="text-red-500 text-xs font-medium mt-1 block">{{ $message }}</span> @enderror
                            </div>

                            <div>
                                <label for="rate" class="block text-sm font-medium text-gray-700 mb-1">Tax Rate (%)
                                    <span class="text-red-500">*</span></label>
                                <div class="relative rounded-md shadow-sm">
                                    <input type="number" step="0.01" name="rate" id="rate"
                                        class="block w-full pr-10 rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 shadow-sm transition-colors"
                                        placeholder="18.00" required value="{{ old('rate', $taxRate->rate) }}">
                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">%</span>
                                    </div>
                                </div>
                                <p class="mt-1 text-xs text-gray-500">The percentage value of the tax.</p>
                                @error('rate') <span
                                class="text-red-500 text-xs font-medium mt-1 block">{{ $message }}</span> @enderror
                            </div>

                            <div class="flex items-center">
                                <input type="hidden" name="is_active" value="0">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="is_active" value="1" class="sr-only peer" {{ old('is_active', $taxRate->is_active) ? 'checked' : '' }}>
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                                    </div>
                                    <span class="ms-3 text-sm font-medium text-gray-700">Active Status</span>
                                </label>
                            </div>
                        </div>

                        <div class="flex items-center justify-end pt-4 border-t border-gray-100 mt-6">
                            <a href="{{ route('admin.tax-rates.index') }}"
                                class="text-gray-600 hover:text-gray-800 text-sm font-medium mr-4 px-4 py-2 rounded-lg hover:bg-gray-100 transition-colors">Cancel</a>
                            <button type="submit"
                                class="bg-blue-600 text-white px-6 py-2.5 rounded-lg text-sm font-bold hover:bg-blue-700 focus:ring-4 focus:ring-blue-300 transition-colors shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
                                Update Tax Rate
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>