<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shipping Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Shipping Settings</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow">
                <div class="p-6">
                    <form action="{{ route('admin.settings.shipping.update') }}" method="POST">
                        @csrf

                        <h3 class="text-lg font-medium leading-6 text-gray-900 mb-6">Shipping Charges</h3>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                            <!-- Local Shipping -->
                            <div>
                                <label for="shipping_local_amount" class="block text-sm font-medium text-gray-700">Local
                                    Shipping Amount (₹)</label>
                                <div class="mt-1 relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">₹</span>
                                    </div>
                                    <input type="number" step="0.01" name="shipping_local_amount"
                                        id="shipping_local_amount"
                                        value="{{ old('shipping_local_amount', $settings->shipping_local_amount ?? 0) }}"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md border py-2"
                                        placeholder="0.00">
                                </div>
                                <p class="mt-2 text-sm text-gray-500">Shipping charge for local deliveries.</p>
                            </div>

                            <!-- National Shipping -->
                            <div>
                                <label for="shipping_national_amount"
                                    class="block text-sm font-medium text-gray-700">National
                                    Shipping (India) Amount (₹)</label>
                                <div class="mt-1 relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">₹</span>
                                    </div>
                                    <input type="number" step="0.01" name="shipping_national_amount"
                                        id="shipping_national_amount"
                                        value="{{ old('shipping_national_amount', $settings->shipping_national_amount ?? 0) }}"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md border py-2"
                                        placeholder="0.00">
                                </div>
                                <p class="mt-2 text-sm text-gray-500">Shipping charge for deliveries across India.</p>
                            </div>

                            <!-- International Shipping -->
                            <div>
                                <label for="shipping_international_amount"
                                    class="block text-sm font-medium text-gray-700">International Shipping Amount
                                    (₹)</label>
                                <div class="mt-1 relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">₹</span>
                                    </div>
                                    <input type="number" step="0.01" name="shipping_international_amount"
                                        id="shipping_international_amount"
                                        value="{{ old('shipping_international_amount', $settings->shipping_international_amount ?? 0) }}"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md border py-2"
                                        placeholder="0.00">
                                </div>
                                <p class="mt-2 text-sm text-gray-500">Shipping charge for international deliveries.</p>
                            </div>
                        </div>

                        <div class="flex justify-end border-t border-gray-200 pt-5">
                            <button type="submit"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Save Changes
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>