@extends('layouts.admin')

@section('title', 'Policy Rules')

@section('content')
    <div class="sm:flex sm:items-center sm:justify-between mb-8">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Policy Rules</h1>
            <p class="mt-2 text-sm text-gray-700">Manage cancellation and refund policy rules.</p>
        </div>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            @if(session('success'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                    <p>{{ session('success') }}</p>
                </div>
            @endif

            <form action="{{ route('admin.settings.policy.update') }}" method="POST">
                @csrf

                <div class="space-y-8">

                    <!-- Global Settings -->
                    <div class="bg-gray-50 rounded-lg p-6 border border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">General Settings</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="return_window_days" class="block text-sm font-semibold text-gray-700">Return
                                    Window</label>
                                <div class="mt-2 relative rounded-md shadow-sm">
                                    <input type="number" name="return_window_days" id="return_window_days" min="0"
                                        value="{{ old('return_window_days', $settings->return_window_days ?? 7) }}"
                                        class="focus:ring-blue-500 focus:border-blue-500 block w-full pr-12 sm:text-sm border-gray-300 rounded-md py-2.5">
                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm font-medium">Days</span>
                                    </div>
                                </div>
                                <p class="mt-2 text-xs text-gray-500">The number of days after delivery during which a
                                    customer can initiate a return.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Cancellation Rules -->
                    <div class="bg-white rounded-lg border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Cancellation Policy</h3>
                            <p class="mt-1 text-sm text-gray-500">Define the rules that appear on the cancellation policy
                                page.</p>
                        </div>
                        <div class="p-6">
                            <label for="cancellation_rules" class="sr-only">Cancellation Rules</label>
                            <div class="relative">
                                <textarea id="cancellation_rules" name="cancellation_rules" rows="8"
                                    placeholder="Enter each rule on a new line..."
                                    class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-lg font-mono text-gray-700 leading-relaxed p-4">{{ old('cancellation_rules', is_array($settings->cancellation_rules) ? implode("\n", $settings->cancellation_rules) : $settings->cancellation_rules) }}</textarea>
                                <div class="absolute top-3 right-3">
                                    <span
                                        class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                        Markdown Safe
                                    </span>
                                </div>
                            </div>
                            <p class="mt-2 text-xs text-gray-400 italic">Tip: Use a new line for each separate point/bullet.
                            </p>
                        </div>
                    </div>

                    <!-- Refund Rules -->
                    <div class="bg-white rounded-lg border border-gray-200">
                        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Refund Policy</h3>
                            <p class="mt-1 text-sm text-gray-500">Define the rules that appear on the refund policy page.
                            </p>
                        </div>
                        <div class="p-6">
                            <label for="refund_rules" class="sr-only">Refund Rules</label>
                            <div class="relative">
                                <textarea id="refund_rules" name="refund_rules" rows="8"
                                    placeholder="Enter each rule on a new line..."
                                    class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-lg font-mono text-gray-700 leading-relaxed p-4">{{ old('refund_rules', is_array($settings->refund_rules) ? implode("\n", $settings->refund_rules) : $settings->refund_rules) }}</textarea>
                                <div class="absolute top-3 right-3">
                                    <span
                                        class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                        Markdown Safe
                                    </span>
                                </div>
                            </div>
                            <p class="mt-2 text-xs text-gray-400 italic">Tip: Use a new line for each separate point/bullet.
                            </p>
                        </div>
                    </div>

                </div>

                <div class="mt-8 flex justify-end">
                    <button type="submit"
                        class="bg-indigo-600 border border-transparent rounded-md shadow-sm py-2 px-4 inline-flex justify-center text-sm font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Save Policy Rules
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection