<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notification Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Notification Settings</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow" x-data="{ mail_mailer: '{{ old('mail_mailer', $settings->mail_mailer ?? 'smtp') }}' }">
                <div class="p-6">
                    <form action="{{ route('admin.settings.notification.update') }}" method="POST">
                        @csrf
                        
                        <!-- FCM Stuff ... -->
                        <h3 class="text-lg font-medium leading-6 text-gray-900 mb-6">FCM Configuration (Firebase Cloud Messaging)</h3>
                        <p class="mb-4 text-sm text-gray-500">Configure Firebase settings to send push notifications to app users and delivery agents.</p>

                        <div class="space-y-6">
                            <!-- Toggle FCM -->
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="fcm_enabled" name="fcm_enabled" type="checkbox"
                                        {{ $settings->fcm_enabled ? 'checked' : '' }}
                                        class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="fcm_enabled" class="font-medium text-gray-700">Enable Push Notifications</label>
                                    <p class="text-gray-500">Enable sending push notifications via Firebase.</p>
                                </div>
                            </div>
                            
                            <hr class="border-gray-200">

                            <div class="grid grid-cols-1 gap-6">
                                
                                <!-- Alert Box -->
                                <div class="bg-blue-50 border-l-4 border-blue-400 p-4">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm text-blue-700">
                                                To use the modern Firebase HTTP v1 API (Recommended), you must provide the <strong>Project ID</strong> and the entire content of your <strong>Service Account JSON</strong> file.
                                                <br>
                                                For older legacy support, you can use the Server Key.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Project ID -->
                                <div>
                                    <label for="fcm_project_id" class="block text-sm font-medium text-gray-700">
                                        Firebase Project ID
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="text" name="fcm_project_id" id="fcm_project_id"
                                            value="{{ old('fcm_project_id', $settings->fcm_project_id) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="your-project-id">
                                    </div>
                                </div>

                                <!-- Service Account JSON -->
                                <div>
                                    <label for="fcm_service_account_json" class="block text-sm font-medium text-gray-700">
                                        Service Account JSON Content
                                    </label>
                                    <div class="mt-1">
                                        <textarea id="fcm_service_account_json" name="fcm_service_account_json" rows="10"
                                            class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border border-gray-300 rounded-md font-mono text-xs"
                                            placeholder="{
  &quot;type&quot;: &quot;service_account&quot;,
  &quot;project_id&quot;: &quot;...&quot;,
  ...
}">{{ old('fcm_service_account_json', $settings->fcm_service_account_json) }}</textarea>
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">Paste the entire content of your Firebase Service Account JSON file here.</p>
                                </div>

                                <div class="relative py-4">
                                    <div class="absolute inset-0 flex items-center" aria-hidden="true">
                                        <div class="w-full border-t border-gray-300"></div>
                                    </div>
                                    <div class="relative flex justify-center">
                                        <span class="px-2 bg-white text-sm text-gray-500">Legacy Configuration</span>
                                    </div>
                                </div>

                                <!-- Server Key -->
                                <div>
                                    <label for="fcm_server_key" class="block text-sm font-medium text-gray-700">
                                        FCM Server Key (Legacy)
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="text" name="fcm_server_key" id="fcm_server_key"
                                            value="{{ old('fcm_server_key', $settings->fcm_server_key) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="AAAA...">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">Only required if you are using the legacy FCM API.</p>
                                </div>

                                <div class="relative py-8">
                                    <div class="absolute inset-0 flex items-center" aria-hidden="true">
                                        <div class="w-full border-t border-gray-300"></div>
                                    </div>
                                    <div class="relative flex justify-center">
                                        <span class="px-3 bg-white text-lg font-bold text-gray-900 flex items-center">
                                            <svg class="w-5 h-5 mr-2 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                            </svg>
                                            Email Configuration
                                        </span>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pb-6 border-b border-gray-100">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">Mail Driver</label>
                                        <select name="mail_mailer" x-model="mail_mailer" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md border">
                                            <option value="smtp">SMTP</option>
                                            <option value="mailgun">Mailgun</option>
                                            <option value="ses">Amazon SES</option>
                                            <option value="log">Log (Dev Only)</option>
                                        </select>
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">From Address</label>
                                        <input type="email" name="mail_from_address" value="{{ old('mail_from_address', $settings->mail_from_address) }}"
                                            class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">From Name</label>
                                        <input type="text" name="mail_from_name" value="{{ old('mail_from_name', $settings->mail_from_name) }}"
                                            class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                    </div>
                                </div>

                                <!-- Mailgun Details -->
                                <div class="space-y-6 pt-6 bg-indigo-50/30 p-6 rounded-xl border border-indigo-100 mt-6" x-show="mail_mailer === 'mailgun'" x-cloak>
                                    <h4 class="text-md font-bold text-gray-900 flex items-center">
                                        <img src="https://www.mailgun.com/favicon.ico" class="w-4 h-4 mr-2" />
                                        Mailgun Settings
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div class="md:col-span-2">
                                            <label class="block text-sm font-medium text-gray-700">Mailgun Domain</label>
                                            <input type="text" name="mailgun_domain" value="{{ old('mailgun_domain', $settings->mailgun_domain) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                                placeholder="mg.yourdomain.com">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mailgun Secret</label>
                                            <input type="password" name="mailgun_secret" value="{{ old('mailgun_secret', $settings->mailgun_secret) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mailgun Endpoint</label>
                                            <select name="mailgun_endpoint" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md border">
                                                <option value="api.mailgun.net" {{ $settings->mailgun_endpoint == 'api.mailgun.net' ? 'selected' : '' }}>US (Default)</option>
                                                <option value="api.eu.mailgun.net" {{ $settings->mailgun_endpoint == 'api.eu.mailgun.net' ? 'selected' : '' }}>EU (Europe)</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="space-y-6 pt-6" x-show="mail_mailer === 'smtp'" x-cloak>
                                    <h4 class="text-md font-bold text-gray-900">SMTP Settings</h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div class="md:col-span-2">
                                            <label class="block text-sm font-medium text-gray-700">Mail Host</label>
                                            <input type="text" name="mail_host" value="{{ old('mail_host', $settings->mail_host) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mail Port</label>
                                            <input type="text" name="mail_port" value="{{ old('mail_port', $settings->mail_port) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mail Encryption</label>
                                            <select name="mail_encryption" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md border">
                                                <option value="tls" {{ $settings->mail_encryption == 'tls' ? 'selected' : '' }}>TLS</option>
                                                <option value="ssl" {{ $settings->mail_encryption == 'ssl' ? 'selected' : '' }}>SSL</option>
                                                <option value="null" {{ $settings->mail_encryption == 'null' ? 'selected' : '' }}>None</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mail Username</label>
                                            <input type="text" name="mail_username" value="{{ old('mail_username', $settings->mail_username) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Mail Password</label>
                                            <input type="password" name="mail_password" value="{{ old('mail_password', $settings->mail_password) }}"
                                                class="mt-1 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3">
                                        </div>
                                    </div>
                                </div>

                            </div>
                           
                        <div class="flex justify-end border-t border-gray-200 mt-8 pt-5">
                            <button type="submit"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>
