<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logistics Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">

    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Logistics Settings</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow">
                <div class="p-6">
                    <form action="{{ route('admin.settings.logistics.update') }}" method="POST">
                        @csrf

                        <h3 class="text-lg font-medium leading-6 text-gray-900 mb-6">Shiprocket Configuration</h3>
                        <p class="mb-4 text-sm text-gray-500">Configure Shiprocket for automated shipping assignments.</p>

                        <div class="space-y-6">
                            <!-- Toggle Shiprocket -->
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="shiprocket_enabled" name="shiprocket_enabled" type="checkbox"
                                        {{ $settings->shiprocket_enabled ? 'checked' : '' }}
                                        class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="shiprocket_enabled" class="font-medium text-gray-700">Enable Shiprocket</label>
                                    <p class="text-gray-500">Enable automated shipping integration with Shiprocket.</p>
                                </div>
                            </div>
                            
                            <hr class="border-gray-200">

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                
                                <!-- Email -->
                                <div>
                                    <label for="shiprocket_email" class="block text-sm font-medium text-gray-700">
                                        Shiprocket Email
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="email" name="shiprocket_email" id="shiprocket_email"
                                            value="{{ old('shiprocket_email', $settings->shiprocket_email) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="email@example.com">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">The email address associated with your Shiprocket account.</p>
                                </div>

                                <!-- Password -->
                                <div>
                                    <label for="shiprocket_password" class="block text-sm font-medium text-gray-700">
                                        Shiprocket Password
                                    </label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="password" name="shiprocket_password" id="shiprocket_password"
                                            value="{{ old('shiprocket_password', $settings->shiprocket_password) }}"
                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md border py-2 px-3"
                                            placeholder="********">
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">The password for your Shiprocket account (used to generate auth tokens).</p>
                                </div>

                            </div>
                           
                        <div class="flex justify-end border-t border-gray-200 mt-8 pt-5">
                            <button type="submit"
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Save Logistics Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>
