<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gateway Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Payment Gateway Settings</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                @if(session('success'))
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                        {{ session('success') }}
                    </div>
                @endif
                @if ($errors->any())
                    <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700 font-medium">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.settings.gateway.update') }}" method="POST" class="space-y-6">
                    @csrf

                    <!-- Razorpay Section -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">Razorpay</h3>
                            <div class="flex items-center">
                                <label for="razorpay_enabled" class="text-sm font-medium text-gray-700 mr-2">Enable
                                    Razorpay</label>
                                <div
                                    class="relative inline-block w-10 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="razorpay_enabled" id="razorpay_enabled" {{ $settings->razorpay_enabled ? 'checked' : '' }}
                                        class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer border-gray-300 transition-transform duration-200 ease-in-out checked:translate-x-full checked:border-blue-600" />
                                    <label for="razorpay_enabled"
                                        class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer checked:bg-blue-600"></label>
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Key ID</label>
                                <input type="text" name="razorpay_key_id"
                                    value="{{ old('razorpay_key_id', $settings->razorpay_key_id) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Key Secret</label>
                                <input type="password" name="razorpay_key_secret"
                                    value="{{ old('razorpay_key_secret', $settings->razorpay_key_secret) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                        </div>
                    </div>

                    <!-- CCAvenue Section -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">CCAvenue</h3>
                            <div class="flex items-center">
                                <label for="ccavenue_enabled" class="text-sm font-medium text-gray-700 mr-2">Enable
                                    CCAvenue</label>
                                <div
                                    class="relative inline-block w-10 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="ccavenue_enabled" id="ccavenue_enabled" {{ $settings->ccavenue_enabled ? 'checked' : '' }}
                                        class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer border-gray-300 transition-transform duration-200 ease-in-out checked:translate-x-full checked:border-blue-600" />
                                    <label for="ccavenue_enabled"
                                        class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer checked:bg-blue-600"></label>
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Merchant ID</label>
                                <input type="text" name="ccavenue_merchant_id"
                                    value="{{ old('ccavenue_merchant_id', $settings->ccavenue_merchant_id) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Access Code</label>
                                <input type="text" name="ccavenue_access_code"
                                    value="{{ old('ccavenue_access_code', $settings->ccavenue_access_code) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Encryption Key</label>
                                <input type="text" name="ccavenue_encryption_key"
                                    value="{{ old('ccavenue_encryption_key', $settings->ccavenue_encryption_key) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                        </div>
                    </div>

                    <!-- PhonePe Section -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">PhonePe</h3>
                            <div class="flex items-center">
                                <label for="phonepe_enabled" class="text-sm font-medium text-gray-700 mr-2">Enable
                                    PhonePe</label>
                                <div
                                    class="relative inline-block w-10 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="phonepe_enabled" id="phonepe_enabled" {{ $settings->phonepe_enabled ? 'checked' : '' }}
                                        class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer border-gray-300 transition-transform duration-200 ease-in-out checked:translate-x-full checked:border-blue-600" />
                                    <label for="phonepe_enabled"
                                        class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer checked:bg-blue-600"></label>
                                </div>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Merchant ID</label>
                                <input type="text" name="phonepe_merchant_id"
                                    value="{{ old('phonepe_merchant_id', $settings->phonepe_merchant_id) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Salt Key</label>
                                <input type="text" name="phonepe_salt_key"
                                    value="{{ old('phonepe_salt_key', $settings->phonepe_salt_key) }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Salt Index</label>
                                <input type="text" name="phonepe_salt_index"
                                    value="{{ old('phonepe_salt_index', $settings->phonepe_salt_index ?? '1') }}"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Environment</label>
                                <select name="phonepe_env"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                    <option value="UAT" {{ old('phonepe_env', $settings->phonepe_env) == 'UAT' ? 'selected' : '' }}>UAT (Sandbox)</option>
                                    <option value="PROD" {{ old('phonepe_env', $settings->phonepe_env) == 'PROD' ? 'selected' : '' }}>PROD (Live)</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit"
                            class="bg-blue-600 text-white px-6 py-2 rounded-lg font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Save Gateway Settings
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <style>
        /* Custom Checkbox Toggle Styles because standard checkbox is ugly for toggle */
        /* Actually using simple trick: input:checked + label background change, input matches label area but transparent? */
        /* The logic in HTML above uses a common CSS toggle switch pattern. */

        .toggle-checkbox:checked {
            right: 0;
            border-color: #2563EB;
        }

        .toggle-checkbox:checked+.toggle-label {
            background-color: #93C5FD;
            /* lighter blue for track */
        }
    </style>
</body>

</html>