<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Developer Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Developer Settings</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                @if(session('success'))
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                        {{ session('success') }}
                    </div>
                @endif
                @if(session('error'))
                    <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700 font-medium">
                        {{ session('error') }}
                    </div>
                @endif
                @if ($errors->any())
                    <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700 font-medium">
                        <ul class="list-disc pl-5">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="space-y-6">
                    <!-- Cache Management -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Cache Management</h3>
                        <div class="flex items-center justify-between">
                            <div>
                                <h4 class="text-sm font-medium text-gray-700">Clear Application Cache</h4>
                                <p class="text-xs text-gray-500 mt-1">Clears route, config, and view cache. Equivalent
                                    to <code>php artisan optimize:clear</code>.</p>
                            </div>
                            <form action="{{ route('admin.settings.developer.clear-cache') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="bg-yellow-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                    Execute
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- System Build -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">System Build</h3>
                        <div class="flex items-center justify-between">
                            <div>
                                <h4 class="text-sm font-medium text-gray-700">Build Frontend Assets</h4>
                                <p class="text-xs text-gray-500 mt-1">Runs <code>npm run build</code> to compile assets.
                                    Use this after UI changes.</p>
                            </div>
                            <form action="{{ route('admin.settings.developer.run-build') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="bg-blue-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Execute
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Database Management -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Database Management</h3>

                        <!-- Migrate -->
                        <div class="flex items-center justify-between mb-6 pb-6 border-b border-gray-100">
                            <div>
                                <h4 class="text-sm font-medium text-gray-700">Migrate Database</h4>
                                <p class="text-xs text-gray-500 mt-1">Run pending migrations to update database schema.
                                </p>
                            </div>
                            <form action="{{ route('admin.settings.developer.migrate-db') }}" method="POST">
                                @csrf
                                <button type="submit"
                                    class="bg-indigo-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Execute
                                </button>
                            </form>
                        </div>
                        <!-- Export -->
                        <div class="flex items-center justify-between mb-6 pb-6 border-b border-gray-100">
                            <div>
                                <h4 class="text-sm font-medium text-gray-700">Export Database</h4>
                                <p class="text-xs text-gray-500 mt-1">Download a SQL dump of the current database.</p>
                            </div>
                            <a href="{{ route('admin.settings.developer.export-db') }}"
                                class="bg-green-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                Execute
                            </a>
                        </div>

                        <!-- Import -->
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-2">Import Database</h4>
                            <p class="text-xs text-gray-500 mb-4">Upload a SQL file to import into the database.
                                <strong>Warning: This will overwrite existing data.</strong>
                            </p>

                            <form action="{{ route('admin.settings.developer.import-db') }}" method="POST"
                                enctype="multipart/form-data" class="flex items-center gap-4">
                                @csrf
                                <div class="flex-1">
                                    <input type="file" name="sql_file" accept=".sql,.txt" required
                                        class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100 border border-gray-300 rounded-lg">
                                </div>
                                <button type="submit"
                                    class="bg-red-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 shrink-0">
                                    Execute
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Database Seeding -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Database Seeding</h3>

                        <!-- Run All Seeders -->
                        <div class="flex items-center justify-between mb-6 pb-6 border-b border-gray-100">
                            <div>
                                <h4 class="text-sm font-medium text-gray-700">Run All Seeders</h4>
                                <p class="text-xs text-gray-500 mt-1">Execute the <code>DatabaseSeeder</code> class to
                                    populate the database with default data.</p>
                            </div>
                            <form action="{{ route('admin.settings.developer.db-seed') }}" method="POST"
                                onsubmit="return confirm('Note: This will run DatabaseSeeder. Are you sure?')">
                                @csrf
                                <button type="submit"
                                    class="bg-purple-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                                    Execute
                                </button>
                            </form>
                        </div>

                        <!-- Run Specific Seeder -->
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-2">Run Specific Seeder</h4>
                            <p class="text-xs text-gray-500 mb-4">Select and execute a specific seeder class.</p>

                            <form action="{{ route('admin.settings.developer.db-seed') }}" method="POST"
                                class="flex items-center gap-4">
                                @csrf
                                <div class="flex-1">
                                    <select name="class" required
                                        class="block w-full text-sm text-gray-700 border border-gray-300 rounded-lg p-2 focus:ring-purple-500 focus:border-purple-500">
                                        <option value="">Select Seeder</option>
                                        @foreach($seeders as $seeder)
                                            <option value="{{ $seeder }}">{{ $seeder }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit"
                                    class="bg-purple-600 text-white px-4 py-2 rounded-lg font-medium hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 shrink-0">
                                    Execute
                                </button>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </main>
    </div>
</body>

</html>