<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Custom Offer - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <a href="{{ route('admin.settings.custom_offers.index') }}" class="mr-4 text-gray-500 hover:text-gray-700">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                </a>
                <h2 class="text-2xl font-semibold text-gray-800">Edit Custom Offer</h2>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                @if ($errors->any())
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">There were errors with your submission</h3>
                                <div class="mt-2 text-sm text-red-700">
                                    <ul class="list-disc pl-5 space-y-1">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

<form action="{{ route('admin.settings.custom_offers.update', $customOffer) }}" method="POST" enctype="multipart/form-data" 
      x-data="{ 
          selectedLayoutId: '{{ old('layout_id', $customOffer->layout_id) }}', 
          layouts: {{ collect($layouts)->toJson() }},
          originalLayoutId: '{{ $customOffer->layout_id }}',
          placementPages: {{ $customOffer->placement_pages ? json_encode($customOffer->placement_pages) : '[]' }},
          targetElement: {{ json_encode(old('target_element', $customOffer->target_element)) }},
          isSubmitting: false,
          bgColor: '{{ old('bg_color', $customOffer->bg_color ?? '#ffffff') }}',
          headingColor: '{{ old('heading_color', $customOffer->heading_color ?? '#111827') }}',
          pageTargets: {
            'home': [
                { id: '#home-hero', label: 'Main Hero Slider' },
                { id: '#home-features', label: 'Features (Quality/Shipping)' },
                { id: '#home-best-sellers', label: 'Best Sellers Section' },
                { id: '#home-consultation', label: 'Video Consultation Form' },
                { id: '#home-collections', label: 'Browse Collections Grid' },
                { id: '#home-instagram', label: 'Instagram Feed' }
            ],
            'shop': [
                { id: '#shop-header', label: 'Shop Header Banner' },
                { id: '#shop-sidebar', label: 'Filters Sidebar' },
                { id: '#products-grid', label: 'Product Grid' }
            ],
            'global': [
                { id: 'header', label: 'Site Header (Nav)' },
                { id: 'footer', label: 'Site Footer' },
                { id: 'main', label: 'Main Webpage Content' }
            ]
          },
          get columns() {
              const layout = this.layouts.find(l => l.id == this.selectedLayoutId);
              return layout ? parseInt(layout.columns) : 0;
          },
          get isLayoutChanged() {
              return String(this.selectedLayoutId) !== String(this.originalLayoutId);
          }
      }"
      @submit="isSubmitting = true">
                    @csrf
                    @method('PUT')
                    
                    <!-- Loader Overlay -->
                    <div x-show="isSubmitting" 
                         style="display: none;"
                         class="fixed inset-0 bg-gray-900 bg-opacity-50 z-50 flex items-center justify-center transition-opacity">
                        <div class="bg-white rounded-lg p-6 flex flex-col items-center shadow-xl">
                            <svg class="animate-spin h-10 w-10 text-blue-600 mb-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <p class="text-gray-700 font-medium">Processing & Compressing Images...</p>
                            <p class="text-gray-500 text-sm mt-1">This may take a few moments.</p>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-medium text-gray-900">Offer Details</h3>
                            <div class="flex items-center">
                                <label for="status" class="mr-2 text-sm text-gray-700">Active</label>
                                <input type="checkbox" name="status" id="status" value="1" {{ $customOffer->status ? 'checked' : '' }} class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Offer Name</label>
                                <input type="text" name="name" id="name" value="{{ old('name', $customOffer->name) }}" required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                            </div>

                            <div>
                                <label for="layout_id" class="block text-sm font-medium text-gray-700">Layout Style</label>
                                <select name="layout_id" id="layout_id" x-model="selectedLayoutId" required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                    @foreach($layouts as $layout)
                                        <option value="{{ $layout->id }}">{{ $layout->name }}</option>
                                    @endforeach
                                </select>
                                <p x-show="isLayoutChanged" class="mt-1 text-sm text-red-600">Warning: Changing the layout will delete existing banner items and replace them with new uploads.</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Placement Pages (Optional)</label>
                                <div class="relative" x-data="{ open: false }">
                                    <button type="button" @click="open = !open" @click.away="open = false"
                                        class="relative w-full bg-white border border-gray-300 rounded-md shadow-sm pl-3 pr-10 py-2 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                        <span class="block truncate" x-text="placementPages.length ? placementPages.length + ' pages selected' : 'Select pages'"></span>
                                        <span class="absolute inset-y-0 right-0 flex items-center pr-2 pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </span>
                                    </button>

                                    <div x-show="open" class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none sm:text-sm"
                                        style="display: none;">
                                        @foreach($pages as $page)
                                            <div class="flex items-center px-4 py-2 hover:bg-gray-100 cursor-pointer">
                                                <input id="page_{{ $page->id }}" name="placement_pages[]" value="{{ $page->slug }}" type="checkbox" x-model="placementPages"
                                                    class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                                <label for="page_{{ $page->id }}" class="ml-3 block text-gray-900 w-full cursor-pointer">
                                                    {{ $page->title }} <span class="text-gray-400 text-xs">(/{{ $page->slug }})</span>
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                            <div>
                                <label for="target_element" class="block text-sm font-medium text-gray-700 mb-1">Target Element Selector (Optional)</label>
                                <input type="text" name="target_element" id="target_element" x-model="targetElement"
                                    placeholder="#main-content, .hero-section"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                <p class="mt-1 text-xs text-gray-500">CSS selector of the element to place this offer relative to.</p>

                                <!-- Quick Select Helper -->
                                <div class="mt-3" x-show="placementPages.length > 0">
                                    <p class="text-xs font-semibold text-gray-600 mb-2">Refence IDs (Click to select):</p>
                                    <div class="flex flex-wrap gap-2">
                                        <!-- Global Targets -->
                                        <template x-for="target in pageTargets.global">
                                            <button type="button" @click="targetElement = target.id"
                                                class="inline-flex items-center px-2.5 py-1.5 border border-gray-200 shadow-sm text-xs font-medium rounded text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                                                :class="targetElement === target.id ? 'ring-2 ring-indigo-500 border-indigo-500 bg-indigo-50' : ''">
                                                <span x-text="target.label"></span>
                                                <span class="ml-1.5 text-gray-400" x-text="'(' + target.id + ')'"></span>
                                            </button>
                                        </template>

                                        <!-- Page Specific Targets -->
                                        <template x-for="page in placementPages">
                                            <template x-if="pageTargets[page]">
                                                <template x-for="target in pageTargets[page]">
                                                    <button type="button" @click="targetElement = target.id"
                                                        class="inline-flex items-center px-2.5 py-1.5 border border-gray-200 shadow-sm text-xs font-medium rounded text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                                                        :class="targetElement === target.id ? 'ring-2 ring-indigo-500 border-indigo-500 bg-indigo-50' : ''">
                                                        <span x-text="target.label"></span>
                                                        <span class="ml-1.5 text-gray-400" x-text="'(' + target.id + ')'"></span>
                                                    </button>
                                                </template>
                                            </template>
                                        </template>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label for="placement_position" class="block text-sm font-medium text-gray-700 mb-1">Placement Position</label>
                                <select name="placement_position" id="placement_position"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="after" {{ $customOffer->placement_position == 'after' ? 'selected' : '' }}>After (Default)</option>
                                    <option value="before" {{ $customOffer->placement_position == 'before' ? 'selected' : '' }}>Before</option>
                                    <option value="inside_start" {{ $customOffer->placement_position == 'inside_start' ? 'selected' : '' }}>Inside (Start)</option>
                                    <option value="inside_end" {{ $customOffer->placement_position == 'inside_end' ? 'selected' : '' }}>Inside (End)</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Custom Styling Section -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6" x-data="{ open: false }">
                         <div class="flex justify-between items-center cursor-pointer" @click="open = !open">
                            <h3 class="text-lg font-medium text-gray-900">Custom Styling (Optional)</h3>
                            <button type="button" class="text-gray-500 hover:text-gray-700">
                                <svg class="w-5 h-5 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                        </div>
                        
                        <div x-show="open" style="display: none;" class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div>
                                <label for="bg_color" class="block text-sm font-medium text-gray-700 mb-1">Background Color</label>
                                <div class="flex items-center">
                                    <input type="color" id="bg_color_picker" x-model="bgColor" class="h-9 w-9 border border-gray-300 rounded-l-md p-1 cursor-pointer">
                                    <input type="text" name="bg_color" id="bg_color" x-model="bgColor" placeholder="#ffffff" 
                                        class="flex-1 block w-full rounded-r-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                </div>
                            </div>

                            <div>
                                <label for="border_radius" class="block text-sm font-medium text-gray-700 mb-1">Border Radius</label>
                                <input type="text" name="border_radius" id="border_radius" value="{{ old('border_radius', $customOffer->border_radius) }}" placeholder="e.g. 10px, 1rem"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                            </div>

                            <div>
                                <label for="box_shadow" class="block text-sm font-medium text-gray-700 mb-1">Box Shadow</label>
                                <select name="box_shadow" id="box_shadow"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="none" {{ old('box_shadow', $customOffer->box_shadow) == 'none' ? 'selected' : '' }}>None</option>
                                    <option value="0 1px 2px 0 rgb(0 0 0 / 0.05)" {{ old('box_shadow', $customOffer->box_shadow) == '0 1px 2px 0 rgb(0 0 0 / 0.05)' ? 'selected' : '' }}>Small</option>
                                    <option value="0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)" {{ old('box_shadow', $customOffer->box_shadow) == '0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)' ? 'selected' : '' }}>Medium</option>
                                    <option value="0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)" {{ old('box_shadow', $customOffer->box_shadow) == '0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)' ? 'selected' : '' }}>Large</option>
                                    <option value="0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)" {{ old('box_shadow', $customOffer->box_shadow) == '0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)' ? 'selected' : '' }}>Extra Large</option>
                                    <option value="0 25px 50px -12px rgb(0 0 0 / 0.25)" {{ old('box_shadow', $customOffer->box_shadow) == '0 25px 50px -12px rgb(0 0 0 / 0.25)' ? 'selected' : '' }}>2XL (Deep)</option>
                                    <option value="inset 0 2px 4px 0 rgb(0 0 0 / 0.05)" {{ old('box_shadow', $customOffer->box_shadow) == 'inset 0 2px 4px 0 rgb(0 0 0 / 0.05)' ? 'selected' : '' }}>Inner Shadow</option>
                                    <option value="0 0 15px rgba(0,0,0,0.15)" {{ old('box_shadow', $customOffer->box_shadow) == '0 0 15px rgba(0,0,0,0.15)' ? 'selected' : '' }}>Soft Glow</option>
                                    <option value="0 0 25px rgba(0,0,0,0.2)" {{ old('box_shadow', $customOffer->box_shadow) == '0 0 25px rgba(0,0,0,0.2)' ? 'selected' : '' }}>Strong Glow</option>
                                    <option value="4px 4px 0px 0px rgba(0,0,0,1)" {{ old('box_shadow', $customOffer->box_shadow) == '4px 4px 0px 0px rgba(0,0,0,1)' ? 'selected' : '' }}>Hard Shadow (Retro)</option>
                                    <option value="0 8px 30px rgba(0,0,0,0.12)" {{ old('box_shadow', $customOffer->box_shadow) == '0 8px 30px rgba(0,0,0,0.12)' ? 'selected' : '' }}>Floating</option>
                                </select>
                            </div>

                            <div>
                                <label for="heading_font_size" class="block text-sm font-medium text-gray-700 mb-1">Heading Size</label>
                                <input type="text" name="heading_font_size" id="heading_font_size" value="{{ old('heading_font_size', $customOffer->heading_font_size) }}" placeholder="e.g. 2rem, 32px"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                            </div>

                             <div>
                                <label for="heading_font_weight" class="block text-sm font-medium text-gray-700 mb-1">Heading Weight</label>
                                <select name="heading_font_weight" id="heading_font_weight"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="400" {{ old('heading_font_weight', $customOffer->heading_font_weight) == '400' ? 'selected' : '' }}>Regular (400)</option>
                                    <option value="500" {{ old('heading_font_weight', $customOffer->heading_font_weight) == '500' ? 'selected' : '' }}>Medium (500)</option>
                                    <option value="600" {{ old('heading_font_weight', $customOffer->heading_font_weight) == '600' ? 'selected' : '' }}>Semi Bold (600)</option>
                                    <option value="700" {{ old('heading_font_weight', $customOffer->heading_font_weight) == '700' ? 'selected' : '' }}>Bold (700)</option>
                                    <option value="800" {{ old('heading_font_weight', $customOffer->heading_font_weight) == '800' ? 'selected' : '' }}>Extra Bold (800)</option>
                                </select>
                            </div>

                            <div>
                                <label for="heading_color" class="block text-sm font-medium text-gray-700 mb-1">Heading Color</label>
                                <div class="flex items-center">
                                    <input type="color" id="heading_color_picker" x-model="headingColor" class="h-9 w-9 border border-gray-300 rounded-l-md p-1 cursor-pointer">
                                    <input type="text" name="heading_color" id="heading_color" x-model="headingColor" placeholder="#111827" 
                                        class="flex-1 block w-full rounded-r-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Existing Items (Only show if layout NOT changed) -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6" x-show="!isLayoutChanged">
                        <fieldSet :disabled="isLayoutChanged" class="contents">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Current Banners</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                @foreach($customOffer->items as $index => $item)
                                    <div class="border border-gray-200 rounded-xl p-5 bg-gray-50 hover:shadow-md transition-shadow duration-200">
                                        <div class="flex items-center justify-between mb-4">
                                            <h4 class="font-semibold text-gray-800">Column {{ $index + 1 }}</h4>
                                            <span class="px-2 py-1 bg-green-100 text-green-700 text-xs rounded-md font-medium">Active</span>
                                        </div>
                                        <input type="hidden" name="item_id[{{ $index }}]" value="{{ $item->id }}">
                                        
                                        <div class="space-y-4">
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Current Image</label>
                                                <div class="relative group rounded-lg overflow-hidden border border-gray-200 shadow-sm aspect-video bg-gray-100">
                                                    <img src="{{ Storage::url($item->banner_image) }}" alt="Current Banner" class="w-full h-full object-cover">
                                                    <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors"></div>
                                                </div>
                                            </div>

                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Replace Image (Optional)</label>
                                                <div class="mt-1 flex justify-center px-4 py-4 border-2 border-gray-300 border-dashed rounded-lg hover:border-indigo-500 transition-colors bg-white">
                                                    <div class="space-y-1 text-center">
                                                        <div class="flex text-sm text-gray-600 justify-center">
                                                            <label for="banner_image_{{ $index }}" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                                                <span>Upload new</span>
                                                                <input id="banner_image_{{ $index }}" name="banner_image[{{ $index }}]" type="file" class="sr-only" accept="image/*">
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="space-y-4 pt-2 border-t border-gray-200">
                                                <div>
                                                    <label class="block text-sm font-medium text-gray-700 mb-1">Redirect URL</label>
                                                    <div class="relative rounded-md shadow-sm">
                                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                            <span class="text-gray-500 sm:text-sm">https://</span>
                                                        </div>
                                                        <input type="url" name="redirect_url[{{ $index }}]" value="{{ old("redirect_url.$index", $item->redirect_url) }}"
                                                            class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-16 sm:text-sm border-gray-300 rounded-md py-2 border" placeholder="www.example.com">
                                                    </div>
                                                </div>

                                                <div>
                                                    <label class="block text-sm font-medium text-gray-700 mb-1">Alt Text</label>
                                                    <input type="text" name="alt_tag[{{ $index }}]" value="{{ old("alt_tag.$index", $item->alt_tag) }}" placeholder="Image description for SEO"
                                                        class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md py-2 border px-3">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </fieldSet>
                    </div>
                    
                    <!-- NEW items fields (Only show if layout CHANGED) -->
                     <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6" x-show="isLayoutChanged">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">New Banners (Layout Changed)</h3>
                        <div class="bg-amber-50 border-l-4 border-amber-400 p-4 mb-6">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-amber-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm text-amber-700">
                                        You are switching to a <span x-text="columns" class="font-bold"></span>-column layout. 
                                        Existing banners will be removed and replaced with new ones.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="grid gap-6" :class="columns === 1 ? 'grid-cols-1' : (columns === 2 ? 'grid-cols-2' : 'grid-cols-3')">
                            <template x-for="i in columns" :key="i">
                                <div class="border border-gray-200 rounded-xl p-5 bg-gray-50 hover:shadow-md transition-shadow duration-200">
                                    <div class="flex items-center justify-between mb-4">
                                        <h4 class="font-semibold text-gray-800" x-text="'Column ' + i"></h4>
                                        <span class="px-2 py-1 bg-gray-200 text-gray-600 text-xs rounded-md font-medium">New</span>
                                    </div>
                                    
                                    <div class="space-y-5">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Banner Image *</label>
                                            <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-indigo-500 transition-colors bg-white">
                                                <div class="space-y-1 text-center">
                                                    <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                                                        <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                    <div class="flex text-sm text-gray-600 justify-center">
                                                        <label :for="'new_banner_image_' + i" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                                            <span>Upload a file</span>
                                                            <input :id="'new_banner_image_' + i" name="banner_image[]" type="file" class="sr-only" required accept="image/*" :disabled="!isLayoutChanged">
                                                        </label>
                                                    </div>
                                                    <p class="text-xs text-gray-500">PNG, JPG, GIF up to 5MB</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Redirect URL</label>
                                            <div class="relative rounded-md shadow-sm">
                                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <span class="text-gray-500 sm:text-sm">https://</span>
                                                </div>
                                                <input type="url" name="redirect_url[]" 
                                                    class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-16 sm:text-sm border-gray-300 rounded-md py-2 border" 
                                                    placeholder="www.example.com" :disabled="!isLayoutChanged">
                                            </div>
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Alt Text</label>
                                            <input type="text" name="alt_tag[]" placeholder="Image description for SEO"
                                                class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md py-2 border px-3" :disabled="!isLayoutChanged">
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </div>

                    <div class="flex justify-end gap-4">
                        <a href="{{ $customOffer->preview_url }}" target="_blank"
                            class="bg-white border border-gray-300 text-gray-700 hover:bg-gray-50 px-6 py-2 rounded-lg text-sm font-medium flex items-center shadow-sm">
                            <svg class="w-5 h-5 mr-2 -ml-1 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                            Preview
                        </a>
                        <button type="submit"
                            :disabled="isSubmitting"
                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed flex items-center">
                            <svg x-show="isSubmitting" style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <span x-text="isSubmitting ? 'Processing...' : 'Update Offer'">Update Offer</span>
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>
