<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cart Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Shopping Cart Settings</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-xl mx-auto">
                @if(session('success'))
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                        {{ session('success') }}
                    </div>
                @endif

                @if($errors->any())
                    <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700">
                        <ul class="list-disc list-inside">
                            @foreach($errors->all() as $error) <li>{{ $error }}</li> @endforeach
                        </ul>
                    </div>
                @endif

                <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                    <form action="{{ route('admin.settings.cart.update') }}" method="POST" class="space-y-6">
                        @csrf

                        <!-- COD Section -->
                        <div x-data="{ 
                            codEnabled: {{ $settings->cod_enabled ? 'true' : 'false' }},
                            freeShippingEnabled: {{ $settings->free_shipping_enabled ? 'true' : 'false' }}
                        }">
                            <div class="flex items-center justify-between py-4 border-b border-gray-100">
                                <div class="flex flex-col">
                                    <h3 class="text-base font-medium text-gray-900">Cash on Delivery (COD)</h3>
                                    <p class="text-sm text-gray-500">Enable or disable COD payment option for customers.
                                    </p>
                                </div>

                                <!-- Hidden inputs for form submission -->
                                <!-- Hidden input for form submission -->
                                <!-- Hidden input for form submission -->
                                <input type="hidden" name="cod_enabled" :value="codEnabled ? '1' : '0'">

                                <button type="button"
                                    class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2"
                                    :class="{ 'bg-blue-600': codEnabled, 'bg-gray-200': !codEnabled }"
                                    @click="codEnabled = !codEnabled" role="switch" :aria-checked="codEnabled">
                                    <span class="sr-only">Toggle COD</span>
                                    <span aria-hidden="true"
                                        class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                                        :class="{ 'translate-x-5': codEnabled, 'translate-x-0': !codEnabled }">
                                    </span>
                                </button>
                            </div>

                            <!-- Min COD Amount -->
                            <div class="py-4 border-b border-gray-100" x-show="codEnabled"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 -translate-y-2"
                                x-transition:enter-end="opacity-100 translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 translate-y-0"
                                x-transition:leave-end="opacity-0 -translate-y-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Min Order Amount for
                                    COD</label>
                                <div class="relative rounded-md shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="text-gray-500 sm:text-sm">₹</span>
                                    </div>
                                    <input type="number" name="min_cod_amount"
                                        value="{{ $settings->min_cod_amount ?? 0 }}"
                                        class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md py-2 border"
                                        placeholder="0.00" min="0" step="0.01">
                                </div>
                                <p class="mt-1 text-xs text-gray-500">Minimum cart total required to enable COD option.
                                </p>
                            </div>
                        </div>

                        <!-- Min Stock Threshold -->
                        <div class="py-4 border-b border-gray-100">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Min Stock Value (Low Stock
                                Threshold)</label>
                            <div class="relative rounded-md shadow-sm">
                                <input type="number" name="min_stock_threshold"
                                    value="{{ $settings->min_stock_threshold ?? 0 }}"
                                    class="focus:ring-blue-500 focus:border-blue-500 block w-full px-3 sm:text-sm border-gray-300 rounded-md py-2 border"
                                    placeholder="0" min="0" step="1">
                            </div>
                            <p class="mt-1 text-xs text-gray-500">Global minimum stock quantity. Products below this
                                stock level will be marked as 'Low Stock'.</p>
                        </div>

                        <!-- Free Shipping -->
                        <div class="py-4">
                            <div class="flex items-center justify-between mb-4">
                                <div>
                                    <h3 class="text-base font-medium text-gray-900">Free Shipping</h3>
                                    <p class="text-sm text-gray-500">Enable free shipping functionality.</p>
                                    <div
                                        class="relative inline-block w-12 mr-2 align-middle select-none transition duration-200 ease-in">
                                        <input type="hidden" name="free_shipping_enabled"
                                            :value="freeShippingEnabled ? '1' : '0'">
                                        <button type="button"
                                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2"
                                            :class="{ 'bg-blue-600': freeShippingEnabled, 'bg-gray-200': !freeShippingEnabled }"
                                            @click="freeShippingEnabled = !freeShippingEnabled" role="switch"
                                            :aria-checked="freeShippingEnabled">
                                            <span class="sr-only">Toggle Free Shipping</span>
                                            <span aria-hidden="true"
                                                class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                                                :class="{ 'translate-x-5': freeShippingEnabled, 'translate-x-0': !freeShippingEnabled }">
                                            </span>
                                        </button>
                                    </div>
                                </div>

                                <div id="shipping_threshold_container" x-show="freeShippingEnabled"
                                    x-transition:enter="transition ease-out duration-200"
                                    x-transition:enter-start="opacity-0 -translate-y-2"
                                    x-transition:enter-end="opacity-100 translate-y-0"
                                    x-transition:leave="transition ease-in duration-150"
                                    x-transition:leave-start="opacity-100 translate-y-0"
                                    x-transition:leave-end="opacity-0 -translate-y-2"
                                    class="mt-4 bg-gray-50 p-4 rounded-lg">
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Free Shipping Amount
                                        Threshold</label>
                                    <div class="relative rounded-md shadow-sm">
                                        <div
                                            class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 sm:text-sm">₹</span>
                                        </div>
                                        <input type="number" name="min_order_amount_for_free_shipping"
                                            value="{{ $settings->min_order_amount_for_free_shipping }}"
                                            class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md py-2 border"
                                            placeholder="0.00">
                                    </div>
                                    <p class="mt-1 text-xs text-gray-500">Cart total must be above this amount to
                                        qualify
                                        for free shipping.</p>
                                </div>
                            </div>

                            <div class="pt-4 flex justify-end">
                                <button type="submit"
                                    class="bg-blue-600 text-white px-6 py-2 rounded-lg font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Save Cart Settings
                                </button>
                            </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>

</html>