<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Appearance Settings - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Admin Appearance Settings</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                @if(session('success'))
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                        {{ session('success') }}
                    </div>
                @endif

                <form action="{{ route('admin.settings.appearance.update') }}" method="POST" class="space-y-6" x-data="{ 
                        selectedFont: '{{ $settings->admin_font_family ?? "Inter, sans-serif" }}',
                        selectedSize: '{{ $settings->admin_font_size ?? '16px' }}',
                        updatePreview() {
                            if (!this.selectedFont.includes(',')) {
                                let fontLink = document.getElementById('google-font-preview-link');
                                if (!fontLink) {
                                    fontLink = document.createElement('link');
                                    fontLink.id = 'google-font-preview-link';
                                    fontLink.rel = 'stylesheet';
                                    document.head.appendChild(fontLink);
                                }
                                fontLink.href = `https://fonts.googleapis.com/css2?family=${this.selectedFont.replace(/ /g, '+')}:wght@400;700&display=swap`;
                            }
                        }
                    }" x-init="updatePreview()">
                    @csrf

                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100 text-slate-900">
                        <h3 class="text-lg font-semibold text-gray-900 mb-6 border-b pb-4">Admin Panel Styling</h3>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <!-- Font Family -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Google Font Family</label>
                                @php
                                    $googleFonts = [
                                        'Inter',
                                        'Roboto',
                                        'Open Sans',
                                        'Lato',
                                        'Montserrat',
                                        'Oswald',
                                        'Source Sans Pro',
                                        'Slabo 27px',
                                        'Raleway',
                                        'PT Sans',
                                        'Merriweather',
                                        'Noto Sans',
                                        'Ubuntu',
                                        'Lora',
                                        'Playfair Display',
                                        'Arimo',
                                        'PT Serif',
                                        'Titillium Web',
                                        'Muli',
                                        'Inconsolata',
                                        'Quicksand',
                                        'Dosis',
                                        'Oxygen',
                                        'Cabin',
                                        'Crimson Text',
                                        'Fira Sans',
                                        'Vollkorn',
                                        'Karla',
                                        'Alegreya',
                                        'Work Sans',
                                        'Nanum Gothic',
                                        'PT Sans Narrow',
                                        'Zilla Slab',
                                        'Libre Franklin',
                                        'IBM Plex Sans',
                                        'Archivo Black',
                                        'Spectral',
                                        'DM Sans',
                                        'Manrope',
                                        'Outfit',
                                        'Nunito',
                                        'Kanit',
                                        'Prompt',
                                        'Heebo',
                                        'Assistant',
                                        'Jost',
                                        'Space Grotesk',
                                        'Syne',
                                        'Plus Jakarta Sans',
                                        'Be Vietnam Pro',
                                        'Mulish',
                                        'Lexend',
                                        'Urbanist',
                                        'Bebas Neue',
                                        'Anton',
                                        'Righteous',
                                        'Fredoka One',
                                        'Pacifico',
                                        'Dancing Script',
                                        'Comfortaa',
                                        'Exo 2',
                                        'Orbitron',
                                        'Cinzel',
                                        'Abril Fatface',
                                        'Caveat',
                                        'Shadows Into Light',
                                        'Permanent Marker',
                                        'Amatic SC',
                                        'Satisfy',
                                        'Lobster',
                                        'Courgette',
                                        'Indie Flower',
                                        'Kaushan Script',
                                        'Great Vibes',
                                        'Patua One',
                                        'Josefin Sans',
                                        'Catamaran',
                                        'Questrial',
                                        'Antic Slab',
                                        'Teko',
                                        'Rajdhani',
                                        'Russo One',
                                        'Ubuntu Condensed',
                                        'Varela Round',
                                        'Pathway Gothic One',
                                        'Noticia Text',
                                        'Vidaloka',
                                        'Old Standard TT',
                                        'Cardo',
                                        'Gelasio',
                                        'Crimson Pro',
                                        'Literata',
                                        'Public Sans',
                                        'Source Serif Pro',
                                        'BioRhyme',
                                        'Crete Round',
                                        'Alice',
                                        'Bitter',
                                        'Domine',
                                        'EB Garamond'
                                    ];
                                    sort($googleFonts);
                                @endphp
                                <select name="admin_font_family" x-model="selectedFont" @change="updatePreview()"
                                    class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 bg-gray-50">
                                    <option value="'Inter', sans-serif">Default (Inter)</option>
                                    @foreach($googleFonts as $font)
                                        <option value="{{ $font }}">{{ $font }}</option>
                                    @endforeach
                                </select>
                                <p class="mt-2 text-[11px] text-gray-500 font-medium italic">
                                    Changes will apply across the entire admin dashboard.
                                </p>
                            </div>

                            <!-- Font Size -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Base Font Size</label>
                                <select name="admin_font_size" x-model="selectedSize"
                                    class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 bg-gray-50">
                                    @for($i = 12; $i <= 24; $i++)
                                        <option value="{{ $i }}px">{{ $i }}px</option>
                                    @endfor
                                    <option value="14px">14px (Recommended)</option>
                                    <option value="16px">16px (Standard)</option>
                                    <option value="0.875rem">0.875rem</option>
                                    <option value="1rem">1rem</option>
                                </select>
                                <p class="mt-2 text-[11px] text-gray-500 font-medium italic">
                                    Default is 16px. Adjust for better readability.
                                </p>
                            </div>
                        </div>

                        <!-- Live Preview Card -->
                        <div
                            class="mt-10 p-8 border-2 border-dashed border-gray-200 rounded-2xl bg-slate-50 relative overflow-hidden">
                            <div
                                class="absolute top-4 right-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest bg-white px-3 py-1 rounded-full shadow-sm border border-slate-100">
                                Live Preview</div>
                            <div class="space-y-4">
                                <h4 class="text-xl font-bold tracking-tight text-slate-900"
                                    :style="{ fontFamily: selectedFont.includes(',') ? selectedFont : `'${selectedFont}', sans-serif`, fontSize: selectedSize }">
                                    The quick brown fox jumps over the lazy dog
                                </h4>
                                <p class="text-slate-600 leading-relaxed max-w-2xl"
                                    :style="{ fontFamily: selectedFont.includes(',') ? selectedFont : `'${selectedFont}', sans-serif`, fontSize: selectedSize }">
                                    Sphinx of black quartz, judge my vow. Heavy boxes full of giant stored prizes. How
                                    quickly daft jumping zebras vex.
                                    This is a live preview of your selected font and size. Once you click save, these
                                    styles will be applied to all
                                    menus, headings, and data tables in the Lugani Admin panel.
                                </p>
                                <div class="flex gap-4 pt-4">
                                    <div class="h-10 w-24 rounded-lg bg-blue-600 flex items-center justify-center text-white text-xs font-bold shadow-lg"
                                        :style="{ fontFamily: selectedFont.includes(',') ? selectedFont : `'${selectedFont}', sans-serif` }">
                                        Sample Button
                                    </div>
                                    <div class="h-10 w-32 rounded-lg bg-white border border-slate-200 flex items-center justify-center text-slate-900 text-xs font-bold shadow-sm"
                                        :style="{ fontFamily: selectedFont.includes(',') ? selectedFont : `'${selectedFont}', sans-serif` }">
                                        Secondary Action
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit"
                            class="bg-slate-900 text-white px-8 py-3 rounded-xl font-bold hover:bg-slate-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-slate-500 transition-all shadow-lg active:scale-95">
                            Save Appearance Settings
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>

</html>