@extends('layouts.admin')

@section('title', 'Analytics Settings')
@section('header_title', 'Analytics Settings')

@section('content')
    <div class="max-w-4xl mx-auto">
        @if(session('success'))
            <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                {{ session('success') }}
            </div>
        @endif

        @if($errors->any())
            <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700 font-medium">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.settings.analytics.update') }}" method="POST" enctype="multipart/form-data"
            class="space-y-6">
            @csrf

            <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Google Analytics & Search Console</h3>
                <p class="text-sm text-gray-500 mb-4">Configure your Google credentials to enable reports in the dashboard.
                </p>

                <div class="space-y-6">
                    <!-- GA4 Property ID -->
                    <div>
                        <label for="ga4_property_id" class="block text-sm font-medium text-gray-700 mb-1">GA4 Property
                            ID</label>
                        <input type="text" name="ga4_property_id" id="ga4_property_id"
                            value="{{ old('ga4_property_id', $settings->ga4_property_id) }}"
                            class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                            placeholder="e.g. 123456789">
                        <p class="mt-1 text-xs text-gray-500">The numeric Property ID for your Google Analytics 4 property.
                        </p>
                    </div>

                    <!-- GSC Property URL -->
                    <div>
                        <label for="gsc_property_url" class="block text-sm font-medium text-gray-700 mb-1">Google Search
                            Console Property URL</label>
                        <input type="text" name="gsc_property_url" id="gsc_property_url"
                            value="{{ old('gsc_property_url', $settings->gsc_property_url) }}"
                            class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                            placeholder="e.g. https://example.com/">
                        <p class="mt-1 text-xs text-gray-500">The URL property exactly as it appears in Google Search
                            Console.</p>
                    </div>

                    <!-- Service Account JSON -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Google Service Account JSON Key</label>

                        @if($settings->google_auth_json)
                            <div class="mb-2 flex items-center text-green-600">
                                <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7">
                                    </path>
                                </svg>
                                <span class="text-sm font-medium">Credentials file is currently uploaded.</span>
                            </div>
                        @else
                            <div class="mb-2 flex items-center text-gray-500">
                                <span class="text-sm">No credentials uploaded yet.</span>
                            </div>
                        @endif

                        <div
                            class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md">
                            <div class="space-y-1 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none"
                                    viewBox="0 0 48 48" aria-hidden="true">
                                    <path
                                        d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                <div class="flex text-sm text-gray-600">
                                    <label for="google_auth_json_file"
                                        class="relative cursor-pointer bg-white rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500">
                                        <span>Upload a file</span>
                                        <input id="google_auth_json_file" name="google_auth_json_file" type="file"
                                            accept=".json" class="sr-only">
                                    </label>
                                    <p class="pl-1">or drag and drop</p>
                                </div>
                                <p class="text-xs text-gray-500">JSON file only</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <button type="submit"
                    class="bg-blue-600 text-white px-6 py-2.5 rounded-lg text-sm font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 shadow-sm transition-colors">
                    Save Changes
                </button>
            </div>
        </form>
    </div>
@endsection