@extends('layouts.admin')

@section('title', 'Return Details #' . $return->id)

@section('content')
    <div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
        <!-- Header -->
        <div class="mb-8">
            <a href="{{ route('admin.returns.index') }}"
                class="text-sm font-medium text-indigo-500 hover:text-indigo-600 mb-2 block">&larr; Back to Returns</a>
            <h1 class="text-2xl md:text-3xl text-gray-800 font-bold">Return Request #{{ $return->id }}</h1>
            <p class="text-gray-500">Order #{{ $return->order->order_number }}</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Details -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Items -->
                <div class="bg-white shadow-lg rounded-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Items to Return</h3>
                    <table class="w-full text-left">
                        <thead>
                            <tr class="text-xs font-semibold text-gray-500 uppercase border-b border-gray-100">
                                <th class="py-2">Product</th>
                                <th class="py-2 text-right">Price</th>
                                <th class="py-2 text-center">Qty</th>
                                <th class="py-2 text-right">Total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @foreach($return->order->items as $item)
                                <tr>
                                    <td class="py-3">
                                        <div class="font-medium text-gray-800">{{ $item->product->name }}</div>
                                        @if($item->variation)
                                            <div class="text-xs text-gray-500">Var: {{ $item->variation->name ?? 'Default' }}</div>
                                        @endif
                                    </td>
                                    <td class="py-3 text-right">₹{{ number_format($item->price, 2) }}</td>
                                    <td class="py-3 text-center">{{ $item->quantity }}</td>
                                    <td class="py-3 text-right">₹{{ number_format($item->total, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="font-bold border-t border-gray-100">
                                <td colspan="3" class="py-3 text-right uppercase">Total Refundable</td>
                                <td class="py-3 text-right">₹{{ number_format($return->order->total, 2) }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- Return Info -->
                <div class="bg-white shadow-lg rounded-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Return Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 uppercase">Customer Reason</label>
                            <p class="mt-1 text-gray-900 bg-gray-50 p-3 rounded-md italic">"{{ $return->reason }}"</p>
                        </div>
                        @if($return->admin_note)
                            <div>
                                <label class="block text-sm font-medium text-gray-500 uppercase">Admin Note</label>
                                <p class="mt-1 text-gray-900 bg-yellow-50 p-3 rounded-md">{{ $return->admin_note }}</p>
                            </div>
                        @endif
                        @if($return->refunded_at)
                            <div class="col-span-2 border-t pt-4 mt-2">
                                <div class="flex justify-between items-center">
                                    <div>
                                        <span class="block text-sm font-bold text-green-600 uppercase">Refund Processed</span>
                                        <span
                                            class="text-xs text-gray-500">{{ $return->refunded_at->format('M d, Y h:i A') }}</span>
                                    </div>
                                    <div class="text-right">
                                        <span class="block text-lg font-bold text-gray-900">₹{{ $return->refund_amount }}</span>
                                        @if($return->deduction_amount > 0)
                                            <span class="text-xs text-red-500 block">Deduction: -₹{{ $return->deduction_amount }}
                                                ({{ $return->deduction_reason }})</span>
                                        @endif
                                    </div>
                                    </div>
                                </div>
                                @if($return->refund_proof_path)
                                    <div class="mt-4 pt-4 border-t border-gray-100">
                                        <span class="block text-xs font-bold text-gray-500 uppercase mb-2">Refund Proof</span>
                                        <a href="{{ asset('storage/' . $return->refund_proof_path) }}" target="_blank"
                                            class="inline-flex items-center px-3 py-1.5 border border-indigo-200 rounded-md text-indigo-700 bg-indigo-50 hover:bg-indigo-100 text-sm font-medium transition-colors">
                                            <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13" />
                                            </svg>
                                            View Uploaded Document
                                        </a>
                                    </div>
                                @endif
                        @endif
                    </div>
                </div>
            </div>

            <!-- Sidebar Actions -->
            <div class="space-y-6">
                <!-- Status Card -->
                <div class="bg-white shadow-lg rounded-sm border border-gray-200 p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Actions</h3>

                    <div class="mb-6">
                        <span class="block text-sm font-medium text-gray-500 mb-1">Current Status</span>
                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full 
                                        {{ $return->status == 'requested' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $return->status == 'approved' ? 'bg-blue-100 text-blue-800' : '' }}
                                        {{ $return->status == 'rejected' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $return->status == 'received' ? 'bg-purple-100 text-purple-800' : '' }}
                                        {{ $return->status == 'refunded' ? 'bg-green-100 text-green-800' : '' }}
                                    ">
                            {{ ucfirst(str_replace('_', ' ', $return->status)) }}
                        </span>
                    </div>

                    @if($return->status == 'requested')
                        <form action="{{ route('admin.returns.update-status', $return->id) }}" method="POST" class="space-y-4">
                            @csrf
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Admin Note (Rejection/Approval)</label>
                                <textarea name="admin_note" rows="3"
                                    class="form-input w-full mt-1 border-gray-300 rounded-md"></textarea>
                            </div>
                            <div class="flex gap-2">
                                <button type="submit" name="status" value="approved"
                                    class="flex-1 inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">Approve</button>
                                <button type="submit" name="status" value="rejected"
                                    class="flex-1 inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">Reject</button>
                            </div>
                        </form>
                    @elseif($return->status == 'approved')
                        <form action="{{ route('admin.returns.update-status', $return->id) }}" method="POST" class="space-y-3">
                            @csrf
                            <div class="bg-blue-50 p-4 rounded-md text-sm text-blue-700">
                                <p class="font-bold mb-1">Next Step: Receive Items</p>
                                Confirm that you have received the return package. This will restock the items.
                            </div>

                            <button type="submit" name="status" value="received"
                                class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                                Mark as Received & Restock
                            </button>

                            <div class="relative flex py-2 items-center">
                                <div class="flex-grow border-t border-gray-200"></div>
                                <span class="flex-shrink-0 mx-2 text-gray-400 text-xs">OR</span>
                                <div class="flex-grow border-t border-gray-200"></div>
                            </div>

                            <button type="submit" name="status" value="refund_initiated"
                                class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Skip to Refund (No Restock)
                            </button>

                            <button type="submit" name="status" value="rejected"
                                onclick="return confirm('Are you sure you want to reject this previously approved return?')"
                                class="w-full inline-flex justify-center items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-red-700 bg-white hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                Cancel & Reject
                            </button>
                        </form>
                    @elseif($return->status == 'received' || $return->status == 'refund_initiated')
                            <div x-data="{ openDeduction: false }">
                                <button @click="openDeduction = !openDeduction"
                                    class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 mb-4">
                                    Process Refund
                                </button>

                                <div x-show="openDeduction" class="mt-4 border-t pt-4">
                                    <form action="{{ route('admin.returns.refund', $return->id) }}" method="POST" enctype="multipart/form-data" class="space-y-4">
                                        @csrf

                                        <!-- User Payment Details -->
                                        <div class="bg-gray-50 p-4 rounded-md border border-gray-200 mb-4">
                                            <h4 class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-2">Refund To
                                                (Default Method)</h4>
                                            @php
                                                $defaultPayment = $return->user->paymentMethods->where('is_default', true)->first();
                                            @endphp

                                            @if($defaultPayment)
                                                <div class="flex items-start">
                                                    <div class="mr-3 mt-0.5">
                                                        @if($defaultPayment->type == 'bank_transfer')
                                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                                stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                    d="M8 14v3m4-3v3m4-3v3M3 21h18M3 10h18M3 7l9-4 9 4M4 10h16v11H4V10z" />
                                                            </svg>
                                                        @else
                                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                                stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                    d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                                            </svg>
                                                        @endif
                                                    </div>
                                                    <div>
                                                        <p class="text-sm font-bold text-gray-800">
                                                            {{ $defaultPayment->type == 'bank_transfer' ? 'Bank Transfer' : 'UPI' }}
                                                        </p>
                                                        @if($defaultPayment->type == 'bank_transfer')
                                                            <p class="text-xs text-gray-600 font-semibold">{{ $defaultPayment->bank_name }}</p>
                                                            <p class="text-xs text-gray-600">A/C: {{ $defaultPayment->account_number }}</p>
                                                            <p class="text-xs text-gray-600">IFSC: {{ $defaultPayment->ifsc_code }}</p>
                                                            <p class="text-xs text-gray-600">Branch: {{ $defaultPayment->branch }}</p>
                                                        @else
                                                            <p class="text-xs text-gray-600">ID: {{ $defaultPayment->upi_id }}</p>
                                                        @endif
                                                    </div>
                                                </div>
                                            @else
                                                <div class="flex items-center text-yellow-600 text-sm">
                                                    <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                                    </svg>
                                                    No default payment method set by user.
                                                </div>
                                            @endif
                                        </div>
                                        <input type="number" step="0.01" name="deduction_amount"
                                            class="form-input w-full mt-1 border-gray-300 rounded-md" placeholder="0.00">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Deduction Reason</label>
                                    <input type="text" name="deduction_reason"
                                        class="form-input w-full mt-1 border-gray-300 rounded-md"
                                        placeholder="e.g. Missing tags, Damaged">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Refund Proof (Image/PDF)</label>
                                    <input type="file" name="refund_proof" accept=".jpg,.jpeg,.png,.pdf"
                                        class="form-input w-full mt-1 border-gray-300 rounded-md">
                                </div>
                                <button type="submit"
                                    class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    Confirm Refund
                                </button>
                                </form>
                            </div>
                        </div>
                    @endif
            </div>

            <!-- User Details -->
            <div class="bg-white shadow-lg rounded-sm border border-gray-200 p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Customer Details</h3>
                <div class="flex items-center mb-4">
                    <div
                        class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-500 font-bold border border-indigo-200">
                        {{ strtoupper(substr($return->user->name, 0, 1)) }}
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-gray-900">{{ $return->user->name }}</p>
                        <p class="text-xs text-gray-500">{{ $return->user->email }}</p>
                    </div>
                </div>
                <div class="text-sm">
                    <a href="{{ route('admin.users.index', ['search' => $return->user->email]) }}"
                        class="text-indigo-500 hover:underline">View History</a>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection