@extends('layouts.admin')

@section('title', 'Manage Returns')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
    <!-- Page header -->
    <div class="sm:flex sm:justify-between sm:items-center mb-8">
        <div class="mb-4 sm:mb-0">
            <h1 class="text-2xl md:text-3xl text-gray-800 font-bold">Manage Returns</h1>
        </div>
    </div>

    <!-- Filters -->
    <div class="mb-5">
        <form action="{{ route('admin.returns.index') }}" method="GET" class="flex flex-wrap gap-2">
            <select name="status" class="form-select pl-3 pr-8 py-2 border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                <option value="">All Statuses</option>
                <option value="requested" {{ request('status') == 'requested' ? 'selected' : '' }}>Requested</option>
                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                <option value="received" {{ request('status') == 'received' ? 'selected' : '' }}>Received</option>
                <option value="refund_initiated" {{ request('status') == 'refund_initiated' ? 'selected' : '' }}>Refund Initiated</option>
                <option value="refunded" {{ request('status') == 'refunded' ? 'selected' : '' }}>Refunded</option>
            </select>
            <button type="submit" class="inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">Filter</button>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-white shadow-lg rounded-sm border border-gray-200">
        <header class="px-5 py-4 border-b border-gray-100">
            <h2 class="font-semibold text-gray-800">Return Requests <span class="text-gray-400 font-medium">({{ $returns->total() }})</span></h2>
        </header>
        <div class="overflow-x-auto">
            <table class="table-auto w-full">
                <thead class="text-xs font-semibold uppercase text-gray-500 bg-gray-50">
                    <tr>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-left">Order</div></th>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-left">Customer</div></th>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-left">Reason</div></th>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-center">Status</div></th>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-right">Date</div></th>
                        <th class="p-2 whitespace-nowrap"><div class="font-semibold text-center">Actions</div></th>
                    </tr>
                </thead>
                <tbody class="text-sm divide-y divide-gray-100">
                    @forelse($returns as $return)
                        <tr>
                            <td class="p-2 whitespace-nowrap">
                                <div class="flex flex-col">
                                    <span class="font-medium text-gray-800">#{{ $return->order->order_number }}</span>
                                    <span class="text-xs text-gray-500">Total: ₹{{ $return->order->total }}</span>
                                </div>
                            </td>
                            <td class="p-2 whitespace-nowrap">
                                <div class="font-medium text-gray-800">{{ $return->user->name }}</div>
                                <div class="text-xs text-gray-500">{{ $return->user->email }}</div>
                            </td>
                            <td class="p-2">
                                <div class="text-gray-600 italic truncate w-64" title="{{ $return->reason }}">
                                    "{{ Str::limit($return->reason, 50) }}"
                                </div>
                            </td>
                            <td class="p-2 whitespace-nowrap text-center">
                                @php
                                    $statusColor = match($return->status) {
                                        'requested' => 'bg-yellow-100 text-yellow-800',
                                        'approved' => 'bg-blue-100 text-blue-800',
                                        'rejected' => 'bg-red-100 text-red-800',
                                        'received' => 'bg-purple-100 text-purple-800',
                                        'refunded' => 'bg-green-100 text-green-800',
                                        default => 'bg-gray-100 text-gray-800'
                                    };
                                @endphp
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColor }}">
                                    {{ ucfirst(str_replace('_', ' ', $return->status)) }}
                                </span>
                            </td>
                            <td class="p-2 whitespace-nowrap text-right">
                                <div class="text-gray-600">{{ $return->created_at->format('M d, Y') }}</div>
                            </td>
                            <td class="p-2 whitespace-nowrap text-center">
                                <a href="{{ route('admin.returns.show', $return->id) }}" class="text-indigo-600 hover:text-indigo-900 font-medium">View Details</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="p-4 text-center text-gray-500">No return requests found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-5 py-3 border-t border-gray-100">
            {{ $returns->withQueryString()->links() }}
        </div>
    </div>
</div>
@endsection
