@extends('layouts.admin')

@section('content')
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h2 class="text-2xl font-bold tracking-tight text-white">Application Details</h2>
            <a href="{{ route('admin.resellers.index') }}" class="text-indigo-400 hover:text-indigo-300">Back to List</a>
        </div>

        @if(session('success'))
            <div class="bg-green-500/10 border border-green-500/20 text-green-400 px-4 py-3 rounded relative" role="alert">
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        @if(session('generated_password'))
            <div
                class="bg-indigo-500/10 border border-indigo-500/50 text-indigo-400 px-6 py-4 rounded-lg relative my-4 shadow-lg">
                <strong class="font-bold text-lg block mb-2">Reseller Credentials Generated:</strong>
                <p class="mb-1">Email: <span
                        class="font-mono text-white bg-slate-700 px-2 py-1 rounded">{{ $reseller->email }}</span></p>
                <p>Password: <span
                        class="font-mono text-xl text-white bg-slate-700 px-3 py-1 rounded select-all">{{ session('generated_password') }}</span>
                </p>
                <p class="text-xs text-slate-400 mt-2">*This password is shown only once. It has also been emailed to the user.
                </p>
            </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Info -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-slate-800 rounded-lg shadow overflow-hidden p-6">
                    <h3 class="text-lg font-medium text-white mb-4 border-b border-slate-700 pb-2">Applicant Information
                    </h3>
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Full Name</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->name }}</dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Email Address</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->email }}</dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Phone</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->phone }}</dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Date Applied</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->created_at->format('M d, Y h:i A') }}</dd>
                        </div>
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-slate-400">Address</dt>
                            <dd class="mt-1 text-sm text-white">
                                {{ $reseller->address }}<br>
                                {{ $reseller->city }}, {{ $reseller->state }} {{ $reseller->postal_code }}
                            </dd>
                        </div>
                    </dl>
                </div>

                <div class="bg-slate-800 rounded-lg shadow overflow-hidden p-6">
                    <h3 class="text-lg font-medium text-white mb-4 border-b border-slate-700 pb-2">Company Information</h3>
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Company Name</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->company_name }}</dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-slate-400">Website</dt>
                            <dd class="mt-1 text-sm text-white">
                                @if($reseller->company_website)
                                    <a href="{{ $reseller->company_website }}" target="_blank"
                                        class="text-indigo-400 hover:text-indigo-300">{{ $reseller->company_website }}</a>
                                @else
                                    <span class="text-slate-500">N/A</span>
                                @endif
                            </dd>
                        </div>
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-slate-400">GST Number</dt>
                            <dd class="mt-1 text-sm text-white">{{ $reseller->gst_number }}</dd>
                        </div>
                    </dl>
                </div>
            </div>

            <!-- Actions -->
            <div class="lg:col-span-1">
                <div class="bg-slate-800 rounded-lg shadow overflow-hidden p-6 sticky top-6">
                    <h3 class="text-lg font-medium text-white mb-4 border-b border-slate-700 pb-2">Actions</h3>

                    <form action="{{ route('admin.resellers.update-status', $reseller->id) }}" method="POST"
                        class="space-y-4">
                        @csrf
                        <div>
                            <label for="status" class="block text-sm font-medium text-slate-400">Status</label>
                            <select id="status" name="status"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-600 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md bg-slate-700 text-white">
                                <option value="pending" {{ $reseller->status == 'pending' ? 'selected' : '' }}>Pending
                                </option>
                                <option value="approved" {{ $reseller->status == 'approved' ? 'selected' : '' }}>Approved
                                </option>
                                <option value="rejected" {{ $reseller->status == 'rejected' ? 'selected' : '' }}>Rejected
                                </option>
                            </select>
                        </div>

                        <div>
                            <label for="admin_notes" class="block text-sm font-medium text-slate-400">Notes
                                (Internal)</label>
                            <textarea id="admin_notes" name="admin_notes" rows="4"
                                class="mt-1 shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-600 rounded-md bg-slate-700 text-white">{{ $reseller->admin_notes }}</textarea>
                        </div>

                        <div class="pt-2">
                            <button type="submit"
                                class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Update Status
                            </button>
                        </div>
                    </form>

                    <div class="mt-8 border-t border-slate-700 pt-6">
                        <h4 class="text-sm font-medium text-slate-400 mb-2">Danger Zone</h4>
                        <form action="{{ route('admin.resellers.destroy', $reseller->id) }}" method="POST"
                            onsubmit="return confirm('Are you sure you want to permanently delete this application?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit"
                                class="w-full flex justify-center py-2 px-4 border border-red-700 rounded-md shadow-sm text-sm font-medium text-red-400 hover:bg-red-900/20 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                Delete Application
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection