<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Traffic Analysis Report - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
    </style>
</head>

<body class="bg-white flex h-screen overflow-hidden text-[#0f172a]">
    @include('admin.partials.sidebar')

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-8 bg-white border-b border-slate-100 relative z-50">
            <div>
                <h2 class="text-xl font-extrabold text-[#0f172a] tracking-tight uppercase">Traffic Analysis</h2>
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Tracking visitor sources &
                    behavior</p>
            </div>

            <form action="{{ route('admin.reports.traffic') }}" method="GET" class="flex items-center gap-4">
                <select name="period" onchange="this.form.submit()"
                    class="px-4 py-2 rounded-xl border border-slate-100 bg-slate-50/50 text-xs font-bold outline-none focus:border-blue-600 transition-all">
                    <option value="">All Time</option>
                    <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>Past 7 Days
                    </option>
                    <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past Month
                    </option>
                    <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past Year</option>
                </select>
            </form>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-white p-8">
            <!-- Stats Overview -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <!-- Top Sources -->
                <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20">
                    <h3 class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-4">Traffic Sources
                    </h3>
                    <div class="space-y-4">
                        @forelse($topSources as $source)
                            <div class="flex items-center justify-between">
                                <span class="text-xs font-bold text-slate-600">{{ $source->source }}</span>
                                <span
                                    class="px-2 py-1 bg-blue-50 text-blue-600 rounded-lg text-[10px] font-black">{{ $source->count }}</span>
                            </div>
                        @empty
                            <p class="text-xs text-slate-400 italic">No data available</p>
                        @endforelse
                    </div>
                </div>

                <!-- Device Breakdown -->
                <div class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20">
                    <h3 class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-4">Device Usage</h3>
                    <div class="space-y-4">
                        @forelse($deviceStats as $stat)
                            <div class="flex items-center justify-between">
                                <span class="text-xs font-bold text-slate-600">{{ $stat->device }}</span>
                                <span
                                    class="px-2 py-1 bg-indigo-50 text-indigo-600 rounded-lg text-[10px] font-black">{{ $stat->count }}</span>
                            </div>
                        @empty
                            <p class="text-xs text-slate-400 italic">No data available</p>
                        @endforelse
                    </div>
                </div>

                <!-- Quick Stats -->
                <div
                    class="bg-white p-6 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 flex flex-col justify-center items-center text-center">
                    <div
                        class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center mb-4">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                        </svg>
                    </div>
                    <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Total Unique
                        Visits</span>
                    <h4 class="text-3xl font-black text-[#0f172a] mt-1">{{ $traffic->total() }}</h4>
                </div>
            </div>

            <!-- Detailed Logs -->
            <div class="bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/20 overflow-hidden">
                <div class="px-8 py-6 border-b border-slate-50 flex justify-between items-center">
                    <h3 class="text-sm font-black text-[#0f172a] uppercase tracking-tight">Recent Traffic Logs</h3>
                </div>
                <table class="w-full">
                    <thead class="bg-slate-50/50">
                        <tr class="text-[10px] font-black text-slate-400 uppercase tracking-widest">
                            <th class="px-6 py-4 text-left">Source</th>
                            <th class="px-6 py-4 text-left">Landing Page</th>
                            <th class="px-6 py-4 text-left">Device</th>
                            <th class="px-6 py-4 text-left">IP Address</th>
                            <th class="px-6 py-4 text-right">Date/Time</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @forelse($traffic as $log)
                            <tr class="hover:bg-slate-50/50 transition-colors">
                                <td class="px-6 py-5">
                                    <div class="flex flex-col">
                                        <span class="text-xs font-extrabold text-[#0f172a]">{{ $log->source }}</span>
                                        @if($log->referrer)
                                            <span class="text-[9px] text-slate-400 truncate max-w-[200px]"
                                                title="{{ $log->referrer }}">{{ $log->referrer }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-5">
                                    <span class="text-xs font-bold text-slate-600 truncate block max-w-[300px]"
                                        title="{{ $log->landing_page }}">{{ str_replace(config('app.url'), '', $log->landing_page) ?: '/' }}</span>
                                </td>
                                <td class="px-6 py-5">
                                    <span
                                        class="px-3 py-1 bg-slate-100 text-slate-600 rounded-lg text-[10px] font-black uppercase tracking-widest">{{ $log->device }}</span>
                                </td>
                                <td class="px-6 py-5">
                                    <span class="text-xs font-medium text-slate-500">{{ $log->ip_address }}</span>
                                </td>
                                <td class="px-6 py-5 text-right">
                                    <span
                                        class="text-xs font-bold text-slate-400">{{ $log->created_at->format('M d, H:i') }}</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5"
                                    class="px-6 py-16 text-center text-[10px] font-bold text-slate-400 uppercase tracking-widest italic">
                                    No traffic data recorded yet.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                {{ $traffic->links() }}
            </div>
        </main>
    </div>
</body>

</html>