<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tax Reports - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Tax Report</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter Toolbar -->
                <div class="p-4 border-b border-gray-200 bg-gray-50/50">
                    <form action="{{ route('admin.reports.tax') }}" method="GET"
                        class="flex flex-wrap items-center gap-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Period:</span>
                            <select name="period" onchange="this.form.submit()"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Custom Range</option>
                                <option value="today" {{ request('period') == 'today' ? 'selected' : '' }}>Today</option>
                                <option value="yesterday" {{ request('period') == 'yesterday' ? 'selected' : '' }}>
                                    Yesterday</option>
                                <option value="this_week" {{ request('period') == 'this_week' ? 'selected' : '' }}>This
                                    Week</option>
                                <option value="last_week" {{ request('period') == 'last_week' ? 'selected' : '' }}>Last
                                    Week</option>
                                <option value="this_month" {{ request('period') == 'this_month' ? 'selected' : '' }}>This
                                    Month</option>
                                <option value="last_month" {{ request('period') == 'last_month' ? 'selected' : '' }}>Last
                                    Month</option>
                                <option value="this_year" {{ request('period') == 'this_year' ? 'selected' : '' }}>This
                                    Year</option>
                                <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>
                                    Past 7 Days</option>
                                <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past
                                    Month</option>
                                <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past
                                    Year</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                            <span class="text-gray-400">to</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                        </div>

                        <div class="flex items-center space-x-2 ml-auto">
                            <button type="submit"
                                class="bg-blue-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-blue-700 transition-colors">Filter</button>
                            <a href="{{ route('admin.reports.tax') }}"
                                class="bg-gray-200 text-gray-700 px-4 py-1.5 rounded-md text-xs font-bold hover:bg-gray-300 transition-colors">Reset</a>
                            <a href="{{ route('admin.reports.tax.pdf', request()->all()) }}" target="_blank"
                                class="bg-red-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-red-700 transition-colors flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                                Export PDF
                            </a>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 text-left">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Date
                                </th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Order
                                    No.</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Customer</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Tax
                                    Rate</th>
                                <th
                                    class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Net Sales (Excl. Tax)</th>
                                <th
                                    class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Tax (GST)</th>
                                <th
                                    class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Total Sales</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @php 
                                                                                                                                                                                                                                                                                                                                $totalNet = 0;
                                $totalTax = 0;
                                $totalGross = 0;
                            @endphp             @forelse($orders as $order)
                                  @php 
                                                                                                                                                                                                                                                                                                                $groups = [];
                                    $orderShipping = $order->shipping_cost ?? 0;

                                    // Process Items
                                    if ($order->items) {
                                        foreach ($order->items as $item) {
                                            $itemGross = $item->price * $item->quantity;
                                            $storedTax = (float) $item->tax_amount;
                                            $storedRate = (float) $item->tax_rate;

                                            $rate = 0;
                                            $itemTax = 0;

                                            if ($storedTax > 0) {
                                                // 1. Priority: Stored Historical Data
                                                $itemTax = $storedTax;
                                                // Use stored rate if valid, else fallback to current product definition
                                                $rate = ($storedRate > 0) ? $storedRate : ($item->product ? ($item->product->tax_code ?? 18) : 18);
                                            } elseif (isset($settings) && $settings->product_tax_enabled) {
                                                // 2. Fallback: Calculation (Back-calculate)
                                                $rate = $item->product ? ($item->product->tax_code ?? 18) : 18;
                                                $itemTax = $itemGross * ($rate / (100 + $rate));
                                            }

                                            $rateKey = (string) $rate; // key for grouping
                                            $itemNet = $itemGross - $itemTax;

                                            // Add to Group
                                            if (!isset($groups[$rateKey])) {
                                                $groups[$rateKey] = [
                                                    'rate' => $rate,
                                                    'net' => 0,
                                                    'tax' => 0,
                                                    'gross' => 0
                                                ];
                                            }
                                            $groups[$rateKey]['net'] += $itemNet;
                                            $groups[$rateKey]['tax'] += $itemTax;
                                            $groups[$rateKey]['gross'] += $itemGross;
                                        }
                                    }

                                    // Add Shipping as a group if exists
                                    if ($orderShipping > 0) {
                                        $shippingTax = 0;
                                        $shippingNet = $orderShipping;
                                        $shippingLabel = 'Shipping';

                                        // Check stored tax
                                        if ($order->shipping_tax_amount > 0) {
                                            $shippingTax = $order->shipping_tax_amount;
                                            $shippingNet = $orderShipping - $shippingTax;
                                            $rate = $order->shipping_tax_rate > 0 ? $order->shipping_tax_rate : 0;
                                            $shippingLabel = 'Shipping (' . (float) $rate . '%)';
                                        } elseif (isset($settings) && $settings->shipping_tax_enabled && isset($shippingTaxRate) && $shippingTaxRate > 0) {
                                            // Inclusive Tax Calculation: Tax = Gross * (Rate / (100 + Rate))
                                            $shippingTax = $orderShipping * ($shippingTaxRate / (100 + $shippingTaxRate));
                                            $shippingNet = $orderShipping - $shippingTax;
                                            $shippingLabel = 'Shipping (' . (float) $shippingTaxRate . '%)';
                                        }

                                        $groups['Shipping'] = [
                                            'rate' => $shippingLabel,
                                            'net' => $shippingNet,
                                            'tax' => $shippingTax,
                                            'gross' => $orderShipping
                                        ];
                                    }

                                    // Sort groups by rate (numeric) then strings
                                    ksort($groups);

                                    $rowCount = count($groups);
                                    if ($rowCount == 0)
                                        continue; // Should not happen for valid orders usually

                                    $firstRow = true;
                                @endphp

                                                                                                        @foreach($groups as $key => $data)
                                                                                                            @php
                                                                                                                $totalNet += $data['net'];
                                                                                                                $totalTax += $data['tax'];
                                                                                                                $totalGross += $data['gross'];
                                                                                                            @endphp
                                                                                                            <tr class="hover:bg-gray-50 transition-colors">
                                                                                                                @if($firstRow)
                                                                                                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500 align-top" rowspan="{{ $rowCount }}">
                                                                                                                        {{ $order->created_at->format('M d, Y') }}
                                                                                                                    </td>
                                                                                                                    <td class="px-6 py-4 whitespace-nowrap text-xs font-medium text-blue-600 align-top" rowspan="{{ $rowCount }}">
                                                                                                                        <a href="{{ route('admin.orders.show', $order->id) }}">#{{ $order->order_number }}</a>
                                                                                                                    </td>
                                                                                                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-900 font-medium align-top" rowspan="{{ $rowCount }}">
                                                                                                                        {{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}
                                                                                                                    </td>
                                                                                                                @endif

                                                                                                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500 border-l border-gray-100">
                                                                                                                    {{ is_numeric($data['rate']) ? $data['rate'] . '%' : $data['rate'] }}
                                                                                                                </td>
                                                                                                                <td class="px-6 py-4 whitespace-nowrap text-right text-xs text-gray-600">
                                                                                                                    ₹{{ number_format($data['net'], 2) }}
                                                                                                                </td>
                                                                                                                <td class="px-6 py-4 whitespace-nowrap text-right text-xs font-bold text-gray-900">
                                                                                                                    ₹{{ number_format($data['tax'], 2) }}
                                                                                                                </td>
                                                                                                                <td class="px-6 py-4 whitespace-nowrap text-right text-xs text-gray-500">
                                                                                                                    ₹{{ number_format($data['gross'], 2) }}
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                            @php $firstRow = false; @endphp
                                                                                                        @endforeach
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-10 text-center text-sm text-gray-500">
                                        No tax data found for the selected period.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="4" class="px-6 py-4 text-right text-sm font-medium text-gray-500 uppercase">Total</td>
                                <td class="px-6 py-4 text-right text-sm font-bold text-gray-900">
                                    ₹{{ number_format($totalNet, 2) }}
                                </td>
                                <td class="px-6 py-4 text-right text-sm font-bold text-gray-900">
                                    ₹{{ number_format($totalTax, 2) }}
                                </td>
                                <td class="px-6 py-4 text-right text-sm font-bold text-gray-900">
                                    ₹{{ number_format($totalGross, 2) }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="p-4 border-t border-gray-200">
                    {{ $orders->links() }}
                </div>
            </div>
        </main>
    </div>
</body>
</html>
