<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shipping Reports - Lugani Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @include('admin.partials.styles')
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    @include('admin.partials.sidebar')
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Shipping Report</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <!-- Filter Toolbar -->
                <div class="p-4 border-b border-gray-200 bg-gray-50/50">
                    <form action="{{ route('admin.reports.shipping') }}" method="GET"
                        class="flex flex-wrap items-center gap-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Period:</span>
                            <select name="period" onchange="this.form.submit()"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">Custom Range</option>
                                <option value="today" {{ request('period') == 'today' ? 'selected' : '' }}>Today</option>
                                <option value="yesterday" {{ request('period') == 'yesterday' ? 'selected' : '' }}>Yesterday</option>
                                <option value="this_week" {{ request('period') == 'this_week' ? 'selected' : '' }}>This Week</option>
                                <option value="last_week" {{ request('period') == 'last_week' ? 'selected' : '' }}>Last Week</option>
                                <option value="this_month" {{ request('period') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                <option value="last_month" {{ request('period') == 'last_month' ? 'selected' : '' }}>Last Month</option>
                                <option value="this_year" {{ request('period') == 'this_year' ? 'selected' : '' }}>This Year</option>
                                <option value="past_7_days" {{ request('period') == 'past_7_days' ? 'selected' : '' }}>Past 7 Days</option>
                                <option value="past_month" {{ request('period') == 'past_month' ? 'selected' : '' }}>Past Month</option>
                                <option value="past_year" {{ request('period') == 'past_year' ? 'selected' : '' }}>Past Year</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 border-l pl-4">
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                            <span class="text-gray-400">to</span>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="text-xs border-gray-300 rounded-md focus:ring-blue-500 py-1.5">
                        </div>
                        
                        <!-- Scope Filter -->
                        <div class="flex items-center space-x-2 border-l pl-4">
                             <select name="scope" class="text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5">
                                <option value="">All Locations</option>
                                <option value="local" {{ request('scope') == 'local' ? 'selected' : '' }}>Local Orders</option>
                                <option value="national" {{ request('scope') == 'national' ? 'selected' : '' }}>National Orders</option>
                                <option value="international" {{ request('scope') == 'international' ? 'selected' : '' }}>International Orders</option>
                            </select>
                        </div>

                        <div class="flex items-center space-x-2 ml-auto">
                            <button type="submit"
                                class="bg-blue-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-blue-700 transition-colors">Filter</button>
                            <a href="{{ route('admin.reports.shipping') }}"
                                class="bg-gray-200 text-gray-700 px-4 py-1.5 rounded-md text-xs font-bold hover:bg-gray-300 transition-colors">Reset</a>
                            <a href="{{ route('admin.reports.shipping.pdf', request()->all()) }}" target="_blank"
                                class="bg-red-600 text-white px-4 py-1.5 rounded-md text-xs font-bold hover:bg-red-700 transition-colors flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                                Export PDF
                            </a>
                        </div>
                    </form>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 text-left">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Order No.</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Location</th>
                                <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Shipping Cost</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @php 
                                $totalShipping = 0; 
                            @endphp
                            @forelse($orders as $order)
                                @php 
                                    $shipping = $order->shipping_cost ?? 0;
                                    $totalShipping += $shipping;
                                @endphp
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        {{ $order->created_at->format('M d, Y') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs font-medium text-blue-600">
                                        <a href="{{ route('admin.orders.show', $order->id) }}">#{{ $order->order_number }}</a>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-900 font-medium">
                                        {{ $order->user ? $order->user->name : ($order->name ?: 'Guest') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        @if($order->shippingAddress)
                                            {{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                        <span class="px-2 py-0.5 inline-flex text-[10px] font-semibold rounded-full 
                                            {{ $order->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                            {{ $order->status == 'processing' ? 'bg-blue-100 text-blue-800' : '' }}
                                            {{ $order->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                            {{ $order->status == 'cancelled' ? 'bg-red-100 text-red-800' : '' }}
                                        ">
                                            {{ strtoupper($order->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-xs font-bold text-gray-900">
                                        ₹{{ number_format($shipping, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-10 text-center text-sm text-gray-500">
                                        No shipping data found for the selected period.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="5" class="px-6 py-4 text-right text-sm font-medium text-gray-500 uppercase">Total Shipping Cost</td>
                                <td class="px-6 py-4 text-right text-sm font-bold text-gray-900">
                                    ₹{{ number_format($totalShipping, 2) }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                
                <div class="p-4 border-t border-gray-200">
                    {{ $orders->links() }}
                </div>
            </div>
        </main>
    </div>
</body>
</html>
